/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit.utils;

import com.excilys.ebi.spring.dbunit.config.DataSetConfiguration;
import com.excilys.ebi.spring.dbunit.config.DatabaseConnectionConfigurer;
import com.excilys.ebi.spring.dbunit.config.ExpectedDataSetConfiguration;
import java.sql.Connection;
import javax.sql.DataSource;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.util.StringUtils;

public class DbUnitUtils {
    public static DataSource lookUpDataSource(ApplicationContext applicationContext, DataSetConfiguration configuration) {
        return DbUnitUtils.lookUpDataSource(applicationContext, configuration.getDataSourceSpringName());
    }

    public static DataSource lookUpDataSource(ApplicationContext applicationContext, String dataSourceSpringName) {
        return dataSourceSpringName != null ? (DataSource)applicationContext.getBean(dataSourceSpringName, DataSource.class) : (DataSource)applicationContext.getBean(DataSource.class);
    }

    public static DatabaseConnection getDatabaseConnection(Connection connection, String schema, DatabaseConnectionConfigurer databaseConnectionConfigurer) throws DatabaseUnitException {
        DatabaseConnection databaseConnection = StringUtils.hasLength((String)schema) ? new DatabaseConnection(connection, schema) : new DatabaseConnection(connection);
        DatabaseConfig databaseConfig = databaseConnection.getConfig();
        databaseConnectionConfigurer.configure(databaseConfig);
        return databaseConnection;
    }

    public static DatabaseConnection getDatabaseConnection(ApplicationContext applicationContext, DatabaseConnectionConfigurer configuration) throws DatabaseUnitException {
        DataSource dataSource = null;
        String schema = null;
        if (configuration instanceof DataSetConfiguration) {
            dataSource = DbUnitUtils.lookUpDataSource(applicationContext, ((DataSetConfiguration)configuration).getDataSourceSpringName());
            schema = ((DataSetConfiguration)configuration).getSchema();
        } else if (configuration instanceof ExpectedDataSetConfiguration) {
            dataSource = DbUnitUtils.lookUpDataSource(applicationContext, ((ExpectedDataSetConfiguration)configuration).getDataSourceSpringName());
            schema = ((ExpectedDataSetConfiguration)configuration).getSchema();
        }
        Connection connection = DataSourceUtils.getConnection(dataSource);
        return DbUnitUtils.getDatabaseConnection(connection, schema, configuration);
    }
}

