/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class ReadableObjectId {
    public final Object id;
    public Object item;
    private LinkedList<Referring> _referringProperties;

    public ReadableObjectId(Object id) {
        this.id = id;
    }

    public void appendReferring(Object pojo, SettableBeanProperty prop) {
        if (this._referringProperties == null) {
            this._referringProperties = new LinkedList();
        }
        this._referringProperties.add(new Referring(pojo, prop));
    }

    public void bindItem(Object ob) throws IOException {
        if (this.item != null) {
            throw new IllegalStateException("Already had POJO for id (" + this.id.getClass().getName() + ") [" + this.id + "]");
        }
        this.item = ob;
        if (this._referringProperties != null) {
            Iterator it = this._referringProperties.iterator();
            this._referringProperties = null;
            while (it.hasNext()) {
                Referring ref = (Referring)it.next();
                ref.property.set(ref.pojo, ob);
            }
        }
    }

    public boolean hasReferringProperties() {
        return this._referringProperties != null && !this._referringProperties.isEmpty();
    }

    public Iterator<Referring> referringProperties() {
        if (this._referringProperties == null) {
            return Collections.emptyList().iterator();
        }
        return this._referringProperties.iterator();
    }

    public static final class Referring {
        public final SettableBeanProperty property;
        public final Object pojo;

        public Referring(Object ob, SettableBeanProperty prop) {
            this.property = prop;
            this.pojo = ob;
        }
    }
}

