/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import com.fasterxml.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;
import org.apache.avro.Schema;

public class MapVisitor
extends JsonMapFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final VisitorFormatWrapperImpl _visitorWrapper;
    protected Schema _valueSchema;
    protected JavaType _keyType;

    public MapVisitor(SerializerProvider p, JavaType type, VisitorFormatWrapperImpl visitorWrapper) {
        super(p);
        this._type = type;
        this._visitorWrapper = visitorWrapper;
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._valueSchema == null) {
            throw new IllegalStateException("Missing value type for " + this._type);
        }
        AnnotatedClass ac = this._provider.getConfig().introspectClassAnnotations(this._keyType).getClassInfo();
        if (AvroSchemaHelper.isStringable(ac)) {
            return AvroSchemaHelper.stringableKeyMapSchema(this._type, this._keyType, this._valueSchema);
        }
        throw new UnsupportedOperationException("Maps with non-stringable keys are not supported (yet?)");
    }

    public void keyFormat(JsonFormatVisitable handler, JavaType keyType) throws JsonMappingException {
        this._keyType = keyType;
    }

    public void valueFormat(JsonFormatVisitable handler, JavaType valueType) throws JsonMappingException {
        VisitorFormatWrapperImpl visitorWrapper = this._visitorWrapper.createChildWrapper();
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitorWrapper, valueType);
        this._valueSchema = visitorWrapper.getAvroSchema();
    }
}

