/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.schema.DefinedSchemas;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import java.util.ArrayList;
import java.util.Set;
import org.apache.avro.Schema;

public class EnumVisitor
extends JsonStringFormatVisitor.Base
implements SchemaBuilder {
    protected final SerializerProvider _provider;
    protected final JavaType _type;
    protected final DefinedSchemas _schemas;
    protected Set<String> _enums;

    public EnumVisitor(SerializerProvider provider, DefinedSchemas schemas, JavaType t) {
        this._schemas = schemas;
        this._type = t;
        this._provider = provider;
    }

    public void enumTypes(Set<String> enums) {
        this._enums = enums;
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._enums == null) {
            throw new IllegalStateException("Possible enum values cannot be null");
        }
        BeanDescription bean = this._provider.getConfig().introspectClassAnnotations(this._type);
        Schema schema = AvroSchemaHelper.createEnumSchema(this._provider.getAnnotationIntrospector(), bean, new ArrayList<String>(this._enums));
        this._schemas.addSchema(this._type, schema);
        return schema;
    }
}

