/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.fasterxml.jackson.dataformat.csv.impl.CsvEncoder;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class CsvGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected final IOContext _ioContext;
    protected int _formatFeatures;
    protected CsvSchema _schema = EMPTY_SCHEMA;
    protected CsvEncoder _writer;
    protected boolean _handleFirstLine = true;
    protected int _nextColumnByName = -1;
    protected boolean _skipValue;
    protected int _arraySeparator = -1;
    protected StringBuilder _arrayContents;
    protected int _arrayElements;

    public CsvGenerator(IOContext ctxt, int jsonFeatures, int csvFeatures, ObjectCodec codec, Writer out, CsvSchema schema) {
        super(jsonFeatures, codec);
        this._ioContext = ctxt;
        this._formatFeatures = csvFeatures;
        this._schema = schema;
        this._writer = new CsvEncoder(ctxt, csvFeatures, out, schema);
    }

    public CsvGenerator(IOContext ctxt, int jsonFeatures, int csvFeatures, ObjectCodec codec, CsvEncoder csvWriter) {
        super(jsonFeatures, codec);
        this._ioContext = ctxt;
        this._formatFeatures = csvFeatures;
        this._writer = csvWriter;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public CsvGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public CsvGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    public Object getOutputTarget() {
        return this._writer.getOutputTarget();
    }

    public int getOutputBuffered() {
        return this._writer.getOutputBuffered();
    }

    public void setSchema(FormatSchema schema) {
        if (schema instanceof CsvSchema) {
            if (this._schema != schema) {
                this._schema = (CsvSchema)schema;
                this._writer = this._writer.withSchema(this._schema);
            }
        } else {
            super.setSchema(schema);
        }
    }

    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    public JsonGenerator overrideFormatFeatures(int values, int mask) {
        this._formatFeatures = this._formatFeatures & ~mask | values & mask;
        return this;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    public boolean canOmitFields() {
        return false;
    }

    public final void writeFieldName(String name) throws IOException {
        if (this._writeContext.writeFieldName(name) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    public final void writeFieldName(SerializableString name) throws IOException {
        if (this._writeContext.writeFieldName(name.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name.getValue());
    }

    public final void writeStringField(String fieldName, String value) throws IOException {
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(fieldName);
        this.writeString(value);
    }

    private final void _writeFieldName(String name) throws IOException {
        CsvSchema.Column col;
        if (this._schema == null) {
            this._reportError("Unrecognized column '" + name + "', can not resolve without CsvSchema");
        }
        if ((col = this._schema.column(name, this._nextColumnByName + 1)) == null) {
            if (this.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
                this._skipValue = true;
                this._nextColumnByName = -1;
                return;
            }
            this._reportError("Unrecognized column '" + name + "': known columns: " + this._schema.getColumnDesc());
        }
        this._skipValue = false;
        this._nextColumnByName = col.getIndex();
    }

    public final boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public CsvGenerator configure(Feature f, boolean state) {
        if (state) {
            return this.enable(f);
        }
        return this.disable(f);
    }

    public CsvGenerator enable(Feature f) {
        this._formatFeatures |= f.getMask();
        this._writer.setFeatures(this._formatFeatures);
        return this;
    }

    public CsvGenerator disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        return this;
    }

    public final void flush() throws IOException {
        this._writer.flush(this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM));
    }

    public void close() throws IOException {
        super.close();
        this.finishRow();
        this._writer.close(this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET));
    }

    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        if (this._writeContext.inObject()) {
            if (!this._skipValue) {
                CsvSchema.Column col;
                int sep = this._nextColumnByName >= 0 ? ((col = this._schema.column(this._nextColumnByName)).isArray() ? col.getArrayElementSeparator() : -1) : -1;
                if (sep <= 0) {
                    if (!this._schema.hasArrayElementSeparator()) {
                        this._reportError("CSV generator does not support Array values for properties without setting 'arrayElementSeparator' in schema");
                    }
                    sep = this._schema.getArrayElementSeparator();
                }
                this._arraySeparator = sep;
                if (this._arrayContents == null) {
                    this._arrayContents = new StringBuilder();
                } else {
                    this._arrayContents.setLength(0);
                }
                this._arrayElements = 0;
            }
        } else if (this._arraySeparator >= 0) {
            this._reportError("CSV generator does not support nested Array values");
        }
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._arraySeparator >= 0) {
            this._arraySeparator = -1;
            this._writer.write(this._columnIndex(), this._arrayContents.toString());
        }
        this._writeContext = this._writeContext.getParent();
        if (!this._writeContext.inObject()) {
            this.finishRow();
        }
    }

    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        if (this._writeContext.inObject()) {
            this._reportError("CSV generator does not support Object values for properties");
        }
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this.finishRow();
    }

    public void writeString(String text) throws IOException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(text);
            } else {
                this._writer.write(this._columnIndex(), text);
            }
        }
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(new String(text, offset, len));
            } else {
                this._writer.write(this._columnIndex(), text, offset, len);
            }
        }
    }

    public final void writeString(SerializableString sstr) throws IOException {
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(sstr.getValue());
            } else {
                this._writer.write(this._columnIndex(), sstr.getValue());
            }
        }
    }

    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len, "UTF-8"));
    }

    public void writeRaw(String text) throws IOException {
        this._writer.writeRaw(text);
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        this._writer.writeRaw(text, offset, len);
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this._writer.writeRaw(text, offset, len);
    }

    public void writeRaw(char c) throws IOException {
        this._writer.writeRaw(c);
    }

    public void writeRawValue(String text) throws IOException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.writeNonEscaped(this._columnIndex(), text);
        }
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.writeNonEscaped(this._columnIndex(), text.substring(offset, offset + len));
        }
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.writeNonEscaped(this._columnIndex(), new String(text, offset, len));
        }
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (!this._skipValue) {
            if (offset > 0 || offset + len != data.length) {
                data = Arrays.copyOfRange(data, offset, offset + len);
            }
            String encoded = b64variant.encode(data);
            if (this._arraySeparator >= 0) {
                this._addToArray(encoded);
            } else {
                this._writer.write(this._columnIndex(), encoded);
            }
        }
    }

    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("write boolean value");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(state ? "true" : "false");
            } else {
                this._writer.write(this._columnIndex(), state);
            }
        }
    }

    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(this._schema.getNullValueOrEmpty());
            } else if (this._writeContext.inObject()) {
                this._writer.writeNull(this._columnIndex());
            }
        }
    }

    public void writeNumber(int v) throws IOException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    public void writeNumber(long v) throws IOException {
        if (v <= Integer.MAX_VALUE && v >= Integer.MIN_VALUE) {
            this.writeNumber((int)v);
            return;
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v.toString());
            }
        }
    }

    public void writeNumber(double v) throws IOException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    public void writeNumber(float v) throws IOException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    public void writeNumber(BigDecimal v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            String str;
            String string = str = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? v.toPlainString() : v.toString();
            if (this._arraySeparator >= 0) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), str);
            }
        }
    }

    public void writeNumber(String encodedValue) throws IOException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (this._arraySeparator >= 0) {
                this._addToArray(encodedValue);
            } else {
                this._writer.write(this._columnIndex(), encodedValue);
            }
        }
    }

    public void writeOmittedField(String fieldName) throws IOException {
        CsvSchema.Column col = this._schema.column(fieldName);
        if (col != null) {
            if (this._writeContext.writeFieldName(fieldName) == 4) {
                this._reportError("Can not skip a field, expecting a value");
            }
            this._nextColumnByName = col.getIndex();
            this._verifyValueWrite("skip positional value due to filtering");
            this._writer.write(this._columnIndex(), "");
        }
    }

    protected final void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
        if (this._handleFirstLine) {
            this._handleFirstLine();
        }
    }

    protected void _releaseBuffers() {
        this._writer._releaseBuffers();
    }

    protected final int _columnIndex() {
        int ix = this._nextColumnByName;
        if (ix < 0) {
            ix = this._writer.nextColumnIndex();
        }
        return ix;
    }

    protected void finishRow() throws IOException {
        this._writer.endRow();
        this._nextColumnByName = -1;
    }

    protected void _handleFirstLine() throws IOException {
        this._handleFirstLine = false;
        if (this._schema.usesHeader()) {
            int count = this._schema.size();
            if (count == 0) {
                this._reportError("Schema specified that header line is to be written; but contains no column names");
            }
            for (CsvSchema.Column column : this._schema) {
                this._writer.writeColumnName(column.getName());
            }
            this._writer.endRow();
        }
    }

    protected void _addToArray(String value) {
        if (this._arrayElements > 0) {
            this._arrayContents.append((char)this._arraySeparator);
        }
        ++this._arrayElements;
        this._arrayContents.append(value);
    }

    protected void _addToArray(char[] value) {
        if (this._arrayElements > 0) {
            this._arrayContents.append((char)this._arraySeparator);
        }
        ++this._arrayElements;
        this._arrayContents.append(value);
    }

    public static enum Feature {
        STRICT_CHECK_FOR_QUOTING(false),
        OMIT_MISSING_TAIL_COLUMNS(false),
        ALWAYS_QUOTE_STRINGS(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

