/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schema;

import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufField;
import java.util.Arrays;

public abstract class FieldLookup {
    public static FieldLookup empty() {
        return Empty.instance;
    }

    public static FieldLookup construct(ProtobufField[] fields) {
        if (fields.length == 0) {
            return Empty.instance;
        }
        switch (fields.length) {
            case 1: {
                return new Small1(fields[0]);
            }
            case 2: {
                return new Small2(fields[0], fields[1]);
            }
            case 3: {
                return new Small3(fields[0], fields[1], fields[2]);
            }
        }
        return Big.construct(fields);
    }

    public abstract ProtobufField findField(String var1);

    static final class Big
    extends FieldLookup {
        private final int _hashMask;
        private final int _spillCount;
        private final String[] _keys;
        private final ProtobufField[] _fields;

        private Big(int hashMask, int spillCount, String[] keys, ProtobufField[] fields) {
            this._hashMask = hashMask;
            this._spillCount = spillCount;
            this._keys = keys;
            this._fields = fields;
        }

        public static Big construct(ProtobufField[] allFields) {
            int size = Big.findSize(allFields.length);
            int mask = size - 1;
            int alloc = size + (size >> 1);
            String[] keys = new String[alloc];
            ProtobufField[] fieldHash = new ProtobufField[alloc];
            int spills = 0;
            for (ProtobufField field : allFields) {
                String key = field.name;
                int slot = key.hashCode() & mask;
                if (keys[slot] != null && keys[slot = size + (slot >> 1)] != null) {
                    slot = size + (size >> 1) + spills;
                    ++spills;
                    if (slot >= keys.length) {
                        keys = Arrays.copyOf(keys, keys.length + 4);
                        fieldHash = Arrays.copyOf(fieldHash, fieldHash.length + 4);
                    }
                }
                keys[slot] = key;
                fieldHash[slot] = field;
            }
            return new Big(mask, spills, keys, fieldHash);
        }

        @Override
        public ProtobufField findField(String key) {
            int slot = key.hashCode() & this._hashMask;
            String match = this._keys[slot];
            if (match == key || key.equals(match)) {
                return this._fields[slot];
            }
            if (match == null) {
                return null;
            }
            match = this._keys[slot = this._hashMask + 1 + (slot >> 1)];
            if (match == key || key.equals(match)) {
                return this._fields[slot];
            }
            return this._findFromSpill(key);
        }

        private static final int findSize(int size) {
            int result;
            if (size <= 5) {
                return 8;
            }
            if (size <= 12) {
                return 16;
            }
            int needed = size + (size >> 2);
            for (result = 32; result < needed; result += result) {
            }
            return result;
        }

        private ProtobufField _findFromSpill(String key) {
            int i;
            int hashSize = this._hashMask + 1;
            int end = i + this._spillCount;
            for (i = hashSize + (hashSize >> 1); i < end; ++i) {
                if (!key.equals(this._keys[i])) continue;
                return this._fields[i];
            }
            return null;
        }
    }

    static final class Small3
    extends FieldLookup {
        protected final String key1;
        protected final String key2;
        protected final String key3;
        protected final ProtobufField field1;
        protected final ProtobufField field2;
        protected final ProtobufField field3;

        Small3(ProtobufField f1, ProtobufField f2, ProtobufField f3) {
            this.key1 = f1.name;
            this.field1 = f1;
            this.key2 = f2.name;
            this.field2 = f2;
            this.key3 = f3.name;
            this.field3 = f3;
        }

        @Override
        public ProtobufField findField(String key) {
            if (key == this.key1) {
                return this.field1;
            }
            if (key == this.key2) {
                return this.field2;
            }
            if (key == this.key3) {
                return this.field3;
            }
            return this._find2(key);
        }

        private final ProtobufField _find2(String key) {
            if (key.equals(this.key1)) {
                return this.field1;
            }
            if (key.equals(this.key2)) {
                return this.field2;
            }
            if (key.equals(this.key3)) {
                return this.field3;
            }
            return null;
        }
    }

    static final class Small2
    extends FieldLookup {
        protected final String key1;
        protected final String key2;
        protected final ProtobufField field1;
        protected final ProtobufField field2;

        Small2(ProtobufField f1, ProtobufField f2) {
            this.key1 = f1.name;
            this.field1 = f1;
            this.key2 = f2.name;
            this.field2 = f2;
        }

        @Override
        public ProtobufField findField(String key) {
            if (key == this.key1) {
                return this.field1;
            }
            if (key == this.key2) {
                return this.field2;
            }
            if (key.equals(this.key1)) {
                return this.field1;
            }
            if (key.equals(this.key2)) {
                return this.field2;
            }
            return null;
        }
    }

    static class Small1
    extends FieldLookup {
        protected final String key1;
        protected final ProtobufField field1;

        Small1(ProtobufField f) {
            this.key1 = f.name;
            this.field1 = f;
        }

        @Override
        public ProtobufField findField(String key) {
            if (key == this.key1 || key.equals(this.key1)) {
                return this.field1;
            }
            return null;
        }
    }

    static class Empty
    extends FieldLookup {
        public static final Empty instance = new Empty();

        private Empty() {
        }

        @Override
        public ProtobufField findField(String key) {
            return null;
        }
    }
}

