/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jakarta.rs.yaml;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.jakarta.rs.cfg.Annotations;
import com.fasterxml.jackson.jakarta.rs.cfg.MapperConfiguratorBase;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import java.util.ArrayList;

public class YAMLMapperConfigurator
extends MapperConfiguratorBase<YAMLMapperConfigurator, YAMLMapper> {
    public YAMLMapperConfigurator(YAMLMapper mapper, Annotations[] defAnnotations) {
        super((ObjectMapper)mapper, defAnnotations);
    }

    public synchronized YAMLMapper getConfiguredMapper() {
        return (YAMLMapper)this._mapper;
    }

    public synchronized YAMLMapper getDefaultMapper() {
        if (this._defaultMapper == null) {
            this._defaultMapper = new YAMLMapper();
            this._setAnnotations(this._defaultMapper, this._defaultAnnotationsToUse);
        }
        return (YAMLMapper)this._defaultMapper;
    }

    protected YAMLMapper mapper() {
        if (this._mapper == null) {
            this._mapper = new YAMLMapper();
            this._setAnnotations(this._mapper, this._defaultAnnotationsToUse);
        }
        return (YAMLMapper)this._mapper;
    }

    protected AnnotationIntrospector _resolveIntrospectors(Annotations[] annotationsToUse) {
        ArrayList<AnnotationIntrospector> intr = new ArrayList<AnnotationIntrospector>();
        for (Annotations a : annotationsToUse) {
            if (a == null) continue;
            intr.add(this._resolveIntrospector(a));
        }
        int count = intr.size();
        if (count == 0) {
            return AnnotationIntrospector.nopInstance();
        }
        AnnotationIntrospector curr = (AnnotationIntrospector)intr.get(0);
        int len = intr.size();
        for (int i = 1; i < len; ++i) {
            curr = AnnotationIntrospector.pair((AnnotationIntrospector)curr, (AnnotationIntrospector)((AnnotationIntrospector)intr.get(i)));
        }
        return curr;
    }

    protected AnnotationIntrospector _resolveIntrospector(Annotations ann) {
        switch (ann) {
            case JACKSON: {
                return new JacksonAnnotationIntrospector();
            }
            case JAKARTA_XML_BIND: {
                try {
                    if (this._xmlBindIntrospectorClass == null) {
                        this._xmlBindIntrospectorClass = JakartaXmlBindAnnotationIntrospector.class;
                    }
                    return (AnnotationIntrospector)this._xmlBindIntrospectorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate JakartaXmlBindAnnotationIntrospector: " + e.getMessage(), e);
                }
            }
        }
        throw new IllegalStateException();
    }
}

