/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.androidrecord;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.introspect.PotentialCreator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.androidrecord.PackageVersion;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AndroidRecordModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.setClassIntrospector((ClassIntrospector)new AndroidRecordClassIntrospector());
        context.insertAnnotationIntrospector((AnnotationIntrospector)new AndroidRecordAnnotationIntrospector());
    }

    static boolean isDesugaredRecordClass(Class<?> raw) {
        Class<?> sup = raw.getSuperclass();
        return sup != null && sup.getName().equals("com.android.tools.r8.RecordTag");
    }

    static Stream<Field> getDesugaredRecordComponents(Class<?> raw) {
        return Arrays.stream(raw.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers()));
    }

    static Class<?> arrayTypeCompat(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    static Type fixAndroidGenericType(Type type) {
        Class rawComponentClass;
        Type rawType;
        ParameterizedType parameterizedType;
        if (type instanceof GenericArrayType) {
            Type componentType = AndroidRecordModule.fixAndroidGenericType(((GenericArrayType)type).getGenericComponentType());
            if (componentType instanceof Class) {
                return AndroidRecordModule.arrayTypeCompat((Class)componentType);
            }
        } else if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getOwnerType() == null && (rawType = parameterizedType.getRawType()) instanceof Class && (rawComponentClass = (Class)rawType).getTypeParameters().length == 0) {
            return rawComponentClass;
        }
        return type;
    }

    static class AndroidRecordAnnotationIntrospector
    extends AnnotationIntrospector {
        private static final long serialVersionUID = 1L;

        AndroidRecordAnnotationIntrospector() {
        }

        public Version version() {
            return PackageVersion.VERSION;
        }

        public PotentialCreator findDefaultCreator(MapperConfig<?> config, AnnotatedClass valueClass, List<PotentialCreator> declaredConstructors, List<PotentialCreator> declaredFactories) {
            PotentialCreator foundCreator = null;
            if (AndroidRecordModule.isDesugaredRecordClass(valueClass.getRawType())) {
                Map<String, Type> components = AndroidRecordModule.getDesugaredRecordComponents(valueClass.getRawType()).collect(Collectors.toMap(Field::getName, Field::getGenericType));
                for (PotentialCreator creator : declaredConstructors) {
                    AnnotatedConstructor constructor;
                    Parameter[] parameters;
                    Map<String, Type> parameterTypes;
                    if (!(creator.creator() instanceof AnnotatedConstructor) || !(parameterTypes = Arrays.stream(parameters = (constructor = (AnnotatedConstructor)creator.creator()).getAnnotated().getParameters()).collect(Collectors.toMap(Parameter::getName, parameter -> AndroidRecordModule.fixAndroidGenericType(parameter.getParameterizedType())))).equals(components)) continue;
                    if (foundCreator != null) {
                        throw new IllegalArgumentException(String.format("Multiple constructors match set of components for record %s", valueClass.getRawType().getName()));
                    }
                    foundCreator = creator.introspectParamNames(config, (PropertyName[])Arrays.stream(parameters).map(Parameter::getName).map(PropertyName::new).toArray(PropertyName[]::new));
                }
            }
            return foundCreator;
        }
    }

    static class AndroidRecordClassIntrospector
    extends BasicClassIntrospector {
        private static final long serialVersionUID = 1L;

        AndroidRecordClassIntrospector() {
        }

        protected POJOPropertiesCollector collectProperties(MapperConfig<?> config, JavaType type, ClassIntrospector.MixInResolver r, boolean forSerialization) {
            if (AndroidRecordModule.isDesugaredRecordClass(type.getRawClass())) {
                AnnotatedClass classDef = this._resolveAnnotatedClass(config, type, r);
                AndroidRecordNaming accNaming = new AndroidRecordNaming(config, classDef);
                return this.constructPropertyCollector(config, classDef, type, forSerialization, (AccessorNamingStrategy)accNaming);
            }
            return super.collectProperties(config, type, r, forSerialization);
        }
    }

    private static final class AndroidRecordNaming
    extends DefaultAccessorNamingStrategy {
        private final Set<String> _componentNames;

        AndroidRecordNaming(MapperConfig<?> config, AnnotatedClass forClass) {
            super(config, forClass, null, "get", "is", null);
            this._componentNames = AndroidRecordModule.getDesugaredRecordComponents(forClass.getRawType()).map(Field::getName).collect(Collectors.toSet());
        }

        public String findNameForRegularGetter(AnnotatedMethod am, String name) {
            if (this._componentNames.contains(name)) {
                return name;
            }
            return super.findNameForRegularGetter(am, name);
        }
    }
}

