/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.guice;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.module.guice.GuiceAnnotationIntrospector;
import com.fasterxml.jackson.module.guice.GuiceInjectableValues;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.binder.ScopedBindingBuilder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class ObjectMapperModule
implements Module {
    private final List<com.fasterxml.jackson.databind.Module> modulesToAdd = new ArrayList<com.fasterxml.jackson.databind.Module>();
    private final List<Key<? extends com.fasterxml.jackson.databind.Module>> modulesToInject = new ArrayList<Key<? extends com.fasterxml.jackson.databind.Module>>();
    private final Key<ObjectMapper> objectMapperKey;
    private ObjectMapper objectMapper;
    private Class<? extends Annotation> scope = null;

    public ObjectMapperModule() {
        this((Key<ObjectMapper>)Key.get(ObjectMapper.class));
    }

    public ObjectMapperModule(Class<? extends Annotation> annotation) {
        this((Key<ObjectMapper>)Key.get(ObjectMapper.class, annotation));
    }

    public ObjectMapperModule(Annotation annotation) {
        this((Key<ObjectMapper>)Key.get(ObjectMapper.class, (Annotation)annotation));
    }

    public ObjectMapperModule(Key<ObjectMapper> objectMapperKey) {
        this.objectMapperKey = objectMapperKey;
    }

    public ObjectMapperModule in(Class<? extends Annotation> scopeAnnotation) {
        this.scope = scopeAnnotation;
        return this;
    }

    public ObjectMapperModule registerModule(com.fasterxml.jackson.databind.Module module) {
        this.modulesToAdd.add(module);
        return this;
    }

    public ObjectMapperModule registerModule(Class<? extends com.fasterxml.jackson.databind.Module> clazz) {
        return this.registerModule((Key<? extends com.fasterxml.jackson.databind.Module>)Key.get(clazz));
    }

    public ObjectMapperModule registerModule(Class<? extends com.fasterxml.jackson.databind.Module> clazz, Class<? extends Annotation> annotation) {
        return this.registerModule((Key<? extends com.fasterxml.jackson.databind.Module>)Key.get(clazz, annotation));
    }

    public ObjectMapperModule registerModule(Class<? extends com.fasterxml.jackson.databind.Module> clazz, Annotation annotation) {
        return this.registerModule((Key<? extends com.fasterxml.jackson.databind.Module>)Key.get(clazz, (Annotation)annotation));
    }

    public ObjectMapperModule registerModule(Key<? extends com.fasterxml.jackson.databind.Module> key) {
        this.modulesToInject.add(key);
        return this;
    }

    public ObjectMapperModule withObjectMapper(ObjectMapper m) {
        this.objectMapper = m;
        return this;
    }

    public void configure(Binder binder) {
        ScopedBindingBuilder builder = binder.bind(this.objectMapperKey).toProvider((Provider)new ObjectMapperProvider(this.modulesToInject, this.modulesToAdd, this.objectMapper));
        if (this.scope != null) {
            builder.in(this.scope);
        }
    }

    private static class ObjectMapperProvider
    implements Provider<ObjectMapper> {
        private final List<Key<? extends com.fasterxml.jackson.databind.Module>> modulesToInject;
        private final List<com.fasterxml.jackson.databind.Module> modulesToAdd;
        private final List<Provider<? extends com.fasterxml.jackson.databind.Module>> providedModules;
        private Injector injector;
        private final ObjectMapper objectMapper;

        public ObjectMapperProvider(List<Key<? extends com.fasterxml.jackson.databind.Module>> modulesToInject, List<com.fasterxml.jackson.databind.Module> modulesToAdd, ObjectMapper mapper) {
            this.modulesToInject = modulesToInject;
            this.modulesToAdd = modulesToAdd;
            this.objectMapper = mapper;
            this.providedModules = new ArrayList<Provider<? extends com.fasterxml.jackson.databind.Module>>();
        }

        @Inject
        public void configure(Injector inj) {
            this.injector = inj;
            for (Key<? extends com.fasterxml.jackson.databind.Module> key : this.modulesToInject) {
                this.providedModules.add((Provider<? extends com.fasterxml.jackson.databind.Module>)this.injector.getProvider(key));
            }
        }

        public ObjectMapper get() {
            ObjectMapper mapper = this.objectMapper;
            mapper = mapper == null ? new ObjectMapper() : mapper.copy();
            mapper.registerModules(this.modulesToAdd);
            for (Provider<? extends com.fasterxml.jackson.databind.Module> provider : this.providedModules) {
                mapper.registerModule((com.fasterxml.jackson.databind.Module)provider.get());
            }
            GuiceAnnotationIntrospector guiceIntrospector = new GuiceAnnotationIntrospector();
            mapper.setInjectableValues((InjectableValues)new GuiceInjectableValues(this.injector));
            mapper.setAnnotationIntrospectors((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, mapper.getSerializationConfig().getAnnotationIntrospector()), (AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, mapper.getDeserializationConfig().getAnnotationIntrospector()));
            return mapper;
        }
    }
}

