/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.osgi;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiInjectableValues
extends InjectableValues {
    private final BundleContext bundleContext;

    public OsgiInjectableValues(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Object findInjectableValue(Object valueId, DeserializationContext ctxt, BeanProperty forProperty, Object beanInstance) {
        return this.findService(OsgiInjectableValues.serviceType(forProperty), this.serviceFilter(valueId));
    }

    private Object findService(String type, String filter) {
        try {
            ServiceReference[] srs = this.bundleContext.getServiceReferences(type, filter);
            if (srs == null || srs.length == 0) {
                return null;
            }
            return this.bundleContext.getService(srs[0]);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static String serviceType(BeanProperty forProperty) {
        return forProperty.getType().toCanonical();
    }

    private String serviceFilter(Object valueId) {
        try {
            return this.bundleContext.createFilter(valueId.toString()).toString();
        }
        catch (InvalidSyntaxException e) {
            return null;
        }
    }
}

