/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.introspect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.module.scala.introspect.ClassHolder;
import com.fasterxml.jackson.module.scala.introspect.WrappedCreatorProperty$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class WrappedCreatorProperty
extends CreatorProperty
implements Product {
    private final CreatorProperty creatorProperty;
    private final ClassHolder refHolder;

    public static WrappedCreatorProperty apply(CreatorProperty creatorProperty, ClassHolder classHolder) {
        return WrappedCreatorProperty$.MODULE$.apply(creatorProperty, classHolder);
    }

    public static WrappedCreatorProperty fromProduct(Product product) {
        return WrappedCreatorProperty$.MODULE$.fromProduct(product);
    }

    public static WrappedCreatorProperty unapply(WrappedCreatorProperty wrappedCreatorProperty) {
        return WrappedCreatorProperty$.MODULE$.unapply(wrappedCreatorProperty);
    }

    public WrappedCreatorProperty(CreatorProperty creatorProperty, ClassHolder refHolder) {
        this.creatorProperty = creatorProperty;
        this.refHolder = refHolder;
        super(creatorProperty, creatorProperty.getFullName());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof WrappedCreatorProperty)) return false;
        WrappedCreatorProperty wrappedCreatorProperty = (WrappedCreatorProperty)((Object)object);
        CreatorProperty creatorProperty = this.creatorProperty();
        CreatorProperty creatorProperty2 = wrappedCreatorProperty.creatorProperty();
        if (creatorProperty == null) {
            if (creatorProperty2 != null) {
                return false;
            }
        } else if (!creatorProperty.equals(creatorProperty2)) return false;
        ClassHolder classHolder = this.refHolder();
        ClassHolder classHolder2 = wrappedCreatorProperty.refHolder();
        if (classHolder == null) {
            if (classHolder2 != null) {
                return false;
            }
        } else if (!((Object)classHolder).equals(classHolder2)) return false;
        if (!wrappedCreatorProperty.canEqual((Object)this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof WrappedCreatorProperty;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "WrappedCreatorProperty";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        if (0 == n2) {
            object = this._1();
        } else if (1 == n2) {
            object = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "creatorProperty";
        } else if (1 == n2) {
            string = "refHolder";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public CreatorProperty creatorProperty() {
        return this.creatorProperty;
    }

    public ClassHolder refHolder() {
        return this.refHolder;
    }

    /*
     * Enabled aggressive block sorting
     */
    public JavaType getType() {
        JavaType other;
        JavaType javaType;
        JavaType javaType2 = super.getType();
        if (javaType2 instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)javaType2;
            if (this.refHolder().valueClass().isDefined()) {
                javaType = this.updateReferenceType(rt, (Class)this.refHolder().valueClass().get());
                return javaType;
            }
        }
        if (javaType2 instanceof CollectionLikeType) {
            CollectionLikeType ct = (CollectionLikeType)javaType2;
            if (this.refHolder().valueClass().isDefined()) {
                javaType = this.updateCollectionType(ct, (Class)this.refHolder().valueClass().get());
                return javaType;
            }
        }
        if (javaType2 instanceof MapLikeType) {
            MapLikeType mt = (MapLikeType)javaType2;
            if (this.refHolder().valueClass().isDefined()) {
                javaType = this.updateMapType(mt, (Class)this.refHolder().valueClass().get());
                return javaType;
            }
        }
        javaType = other = javaType2;
        return javaType;
    }

    private ReferenceType updateReferenceType(ReferenceType rt, Class<?> newRefClass) {
        ReferenceType referenceType;
        JavaType javaType = rt.getContentType();
        if (javaType instanceof ReferenceType) {
            ReferenceType innerRt = (ReferenceType)javaType;
            referenceType = ReferenceType.upgradeFrom((JavaType)rt, (JavaType)this.updateReferenceType(innerRt, newRefClass));
        } else if (javaType instanceof CollectionLikeType) {
            CollectionLikeType innerCt = (CollectionLikeType)javaType;
            referenceType = ReferenceType.upgradeFrom((JavaType)rt, (JavaType)this.updateCollectionType(innerCt, newRefClass));
        } else if (javaType instanceof MapLikeType) {
            MapLikeType innerMt = (MapLikeType)javaType;
            referenceType = ReferenceType.upgradeFrom((JavaType)rt, (JavaType)this.updateMapType(innerMt, newRefClass));
        } else {
            referenceType = ReferenceType.upgradeFrom((JavaType)rt, (JavaType)SimpleType.constructUnsafe(newRefClass));
        }
        return referenceType;
    }

    private CollectionLikeType updateCollectionType(CollectionLikeType ct, Class<?> newRefClass) {
        CollectionLikeType collectionLikeType;
        JavaType javaType = ct.getContentType();
        if (javaType instanceof ReferenceType) {
            ReferenceType innerRt = (ReferenceType)javaType;
            collectionLikeType = CollectionLikeType.upgradeFrom((JavaType)ct, (JavaType)this.updateReferenceType(innerRt, newRefClass));
        } else if (javaType instanceof CollectionLikeType) {
            CollectionLikeType innerCt = (CollectionLikeType)javaType;
            collectionLikeType = CollectionLikeType.upgradeFrom((JavaType)ct, (JavaType)this.updateCollectionType(innerCt, newRefClass));
        } else if (javaType instanceof MapLikeType) {
            MapLikeType innerMt = (MapLikeType)javaType;
            collectionLikeType = CollectionLikeType.upgradeFrom((JavaType)ct, (JavaType)this.updateMapType(innerMt, newRefClass));
        } else {
            collectionLikeType = CollectionLikeType.upgradeFrom((JavaType)ct, (JavaType)SimpleType.constructUnsafe(newRefClass));
        }
        return collectionLikeType;
    }

    private MapLikeType updateMapType(MapLikeType mt, Class<?> newRefClass) {
        MapLikeType mapLikeType;
        JavaType javaType = mt.getContentType();
        if (javaType instanceof ReferenceType) {
            ReferenceType innerRt = (ReferenceType)javaType;
            mapLikeType = MapLikeType.upgradeFrom((JavaType)mt, (JavaType)mt.getKeyType(), (JavaType)this.updateReferenceType(innerRt, newRefClass));
        } else if (javaType instanceof CollectionLikeType) {
            CollectionLikeType innerCt = (CollectionLikeType)javaType;
            mapLikeType = MapLikeType.upgradeFrom((JavaType)mt, (JavaType)mt.getKeyType(), (JavaType)this.updateCollectionType(innerCt, newRefClass));
        } else if (javaType instanceof MapLikeType) {
            MapLikeType innerMt = (MapLikeType)javaType;
            mapLikeType = MapLikeType.upgradeFrom((JavaType)mt, (JavaType)mt.getKeyType(), (JavaType)this.updateMapType(innerMt, newRefClass));
        } else {
            mapLikeType = MapLikeType.upgradeFrom((JavaType)mt, (JavaType)mt.getKeyType(), (JavaType)SimpleType.constructUnsafe(newRefClass));
        }
        return mapLikeType;
    }

    public WrappedCreatorProperty copy(CreatorProperty creatorProperty, ClassHolder refHolder) {
        return new WrappedCreatorProperty(creatorProperty, refHolder);
    }

    public CreatorProperty copy$default$1() {
        return this.creatorProperty();
    }

    public ClassHolder copy$default$2() {
        return this.refHolder();
    }

    public CreatorProperty _1() {
        return this.creatorProperty();
    }

    public ClassHolder _2() {
        return this.refHolder();
    }
}

