/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.ArgumentsUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class GalenActionConfigArguments {
    private Boolean isGlobal = false;

    public static GalenActionConfigArguments parse(String[] args) {
        CommandLine cmd;
        args = ArgumentsUtils.processSystemProperties(args);
        Options options = new Options();
        options.addOption("g", "global", false, "Flag to create global config in user home directory");
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (MissingArgumentException e) {
            throw new IllegalArgumentException("Missing value for " + e.getOption().getLongOpt(), e);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        GalenActionConfigArguments configArguments = new GalenActionConfigArguments();
        configArguments.isGlobal = cmd.hasOption("g");
        return configArguments;
    }

    public Boolean getGlobal() {
        return this.isGlobal;
    }
}

