/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.galenframework.api.Galen;
import com.galenframework.api.PageDump;
import com.galenframework.browser.Browser;
import com.galenframework.browser.SeleniumBrowser;
import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.rainbow4j.Rainbow4J;
import com.galenframework.speclang2.pagespec.PageSpecReader;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.specs.page.Locator;
import com.galenframework.specs.page.PageSpec;
import com.galenframework.utils.GalenUtils;
import com.galenframework.validation.PageValidation;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalenPageDump {
    private static final Logger LOG = LoggerFactory.getLogger(GalenPageDump.class);
    private static final List<String> EMPTY_TAGS = Collections.emptyList();
    private boolean onlyImages = false;
    private String pageName;
    private Integer maxWidth = null;
    private Integer maxHeight = null;
    private Properties properties;
    private Map<String, Object> jsVariables;
    private Map<String, Locator> objects;
    private List<String> excludedObjects;

    public GalenPageDump(String pageName) {
        this.setPageName(pageName);
    }

    public void dumpPage(WebDriver driver, String pageSpecPath, String reportFolderPath) throws IOException {
        SeleniumBrowser browser = new SeleniumBrowser(driver);
        this.dumpPage((Browser)browser, this.loadPageSpec(browser, pageSpecPath), reportFolderPath);
    }

    private PageSpec loadPageSpec(Browser browser, String pageSpecPath) throws IOException {
        PageSpecReader reader = new PageSpecReader();
        return reader.read(pageSpecPath, browser.getPage(), new SectionFilter(EMPTY_TAGS, EMPTY_TAGS), this.properties, this.jsVariables, this.objects);
    }

    public void dumpPage(Browser browser, String pageSpecPath, String reportFolderPath) throws IOException {
        this.dumpPage(browser, this.loadPageSpec(browser, pageSpecPath), reportFolderPath);
    }

    public void dumpPage(Browser browser, PageSpec pageSpec, String reportFolderPath) throws IOException {
        File reportFolder = new File(reportFolderPath);
        if (!reportFolder.exists() && !reportFolder.mkdirs()) {
            throw new RuntimeException("Cannot create dir: " + reportFolder.getAbsolutePath());
        }
        Set<String> objectNames = pageSpec.getObjects().keySet();
        PageValidation pageValidation = new PageValidation(browser, browser.getPage(), pageSpec, null, null);
        PageDump pageDump = new PageDump();
        pageDump.setTitle(browser.getPage().getTitle());
        List<Pattern> patterns = this.convertPatterns(this.excludedObjects);
        HashSet<String> finalObjectNames = new HashSet<String>();
        finalObjectNames.addAll(objectNames);
        finalObjectNames.add("screen");
        finalObjectNames.add("viewport");
        for (String objectName : finalObjectNames) {
            PageElement pageElement;
            if (this.matchesExcludedPatterns(objectName, patterns) || !(pageElement = pageValidation.findPageElement(objectName)).isVisible() || pageElement.getArea() == null) continue;
            PageDump.Element element = new PageDump.Element(objectName, pageElement.getArea().toIntArray());
            if (pageElement.isPresent() && pageElement.isVisible() && GalenPageDump.isWithinArea(pageElement, this.maxWidth, this.maxHeight)) {
                element.setHasImage(true);
            }
            pageDump.addElement(element);
        }
        if (!this.onlyImages) {
            pageDump.setPageName(this.pageName);
            this.exportAsJson(pageDump, new File(reportFolder.getAbsoluteFile() + File.separator + "page.json"));
            this.exportAsHtml(pageDump, this.pageName, new File(reportFolder.getAbsoluteFile() + File.separator + "page.html"));
            GalenPageDump.copyResource("/html-report/vue.js", new File(reportFolder.getAbsolutePath() + File.separator + "vue.js"));
            GalenPageDump.copyResource("/html-report/galen-report.js", new File(reportFolder.getAbsolutePath() + File.separator + "galen-report.js"));
            GalenPageDump.copyResource("/html-report/galen-report.css", new File(reportFolder.getAbsolutePath() + File.separator + "galen-report.css"));
        }
        this.exportAllScreenshots(pageDump, browser, reportFolder);
    }

    private boolean matchesExcludedPatterns(String objectName, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(objectName).matches()) continue;
            return true;
        }
        return false;
    }

    private List<Pattern> convertPatterns(List<String> excludedObjects) {
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        if (excludedObjects != null) {
            for (String excludedObject : excludedObjects) {
                patterns.add(GalenUtils.convertObjectNameRegex(excludedObject));
            }
        }
        return patterns;
    }

    public void exportAsJson(PageDump pageDump, File file) throws IOException {
        this.makeSureFileExists(file);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writeValue(file, (Object)pageDump);
    }

    public void exportAsHtml(PageDump pageDump, String title, File file) throws IOException {
        this.makeSureFileExists(file);
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonText = objectMapper.writeValueAsString((Object)pageDump);
        String template = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/html-report/page-dump.tpl.html"));
        String htmlText = template.replace("${title}", title);
        htmlText = htmlText.replace("${json}", jsonText);
        FileUtils.writeStringToFile((File)file, (String)htmlText);
    }

    public void makeSureFileExists(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new RuntimeException("Couldn't create file: " + file.getAbsolutePath());
        }
    }

    public void exportAllScreenshots(PageDump pageDump, Browser browser, File reportFolder) throws IOException {
        File screenshotOriginalFile = browser.getPage().getScreenshotFile();
        FileUtils.copyFile((File)screenshotOriginalFile, (File)new File(reportFolder.getAbsolutePath() + File.separator + "page.png"));
        BufferedImage image = Rainbow4J.loadImage((String)screenshotOriginalFile.getAbsolutePath());
        File objectsFolder = new File(reportFolder.getAbsolutePath() + File.separator + "objects");
        objectsFolder.mkdirs();
        for (PageDump.Element element : pageDump.getItems().values()) {
            int[] area;
            if (!element.getHasImage() || (area = element.getArea())[0] >= image.getWidth() || area[1] >= image.getHeight()) continue;
            int x = Math.max(area[0], 0);
            int y = Math.max(area[1], 0);
            int x2 = Math.min(area[0] + area[2], image.getWidth());
            int y2 = Math.min(area[1] + area[3], image.getHeight());
            int availableWidth = x2 - x;
            int availableHeight = y2 - y;
            try {
                if (availableWidth > 0 && availableHeight > 0) {
                    BufferedImage subImage = image.getSubimage(x, y, availableWidth, availableHeight);
                    Rainbow4J.saveImage((BufferedImage)subImage, (File)new File(objectsFolder.getAbsolutePath() + File.separator + element.getObjectName() + ".png"));
                    continue;
                }
                element.setHasImage(false);
            }
            catch (Exception ex) {
                LOG.error("Got error during saving image", (Throwable)ex);
            }
        }
        screenshotOriginalFile.deleteOnExit();
    }

    private static void copyResource(String resourceName, File destFile) throws IOException {
        String value = IOUtils.toString((InputStream)Galen.class.getResourceAsStream(resourceName));
        FileUtils.writeStringToFile((File)destFile, (String)value);
    }

    private static boolean isWithinArea(PageElement element, Integer maxWidth, Integer maxHeight) {
        Rect area = element.getArea();
        if (maxWidth != null && maxHeight != null) {
            return maxWidth * maxHeight > area.getWidth() * area.getHeight();
        }
        if (maxWidth != null) {
            return maxWidth > area.getWidth();
        }
        if (maxHeight != null) {
            return maxHeight > area.getHeight();
        }
        return true;
    }

    public String getPageName() {
        return this.pageName;
    }

    public GalenPageDump setPageName(String pageName) {
        this.pageName = pageName;
        return this;
    }

    public GalenPageDump setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public GalenPageDump setJsVariables(Map<String, Object> jsVariables) {
        this.jsVariables = jsVariables;
        return this;
    }

    public void setObjects(Map<String, Locator> objects) {
        this.objects = objects;
    }

    public Integer getMaxHeight() {
        return this.maxHeight;
    }

    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    public GalenPageDump setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public GalenPageDump setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public GalenPageDump setOnlyImages(boolean onlyImages) {
        this.onlyImages = onlyImages;
        return this;
    }

    public boolean isOnlyImages() {
        return this.onlyImages;
    }

    public GalenPageDump setExcludedObjects(List<String> excludedObjects) {
        this.excludedObjects = excludedObjects;
        return this;
    }

    public List<String> getExcludedObjects() {
        return this.excludedObjects;
    }
}

