/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.browser;

import com.galenframework.browser.Browser;
import com.galenframework.page.Page;
import com.galenframework.page.selenium.SeleniumPage;
import com.galenframework.utils.GalenUtils;
import java.awt.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class SeleniumBrowser
implements Browser {
    private WebDriver driver;

    public SeleniumBrowser(WebDriver driver) {
        this.driver = driver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public void quit() {
        this.driver.quit();
    }

    @Override
    public void changeWindowSize(Dimension windowSize) {
        GalenUtils.resizeDriver(this.driver, windowSize.width, windowSize.height);
    }

    @Override
    public void load(String url) {
        this.driver.get(url);
    }

    @Override
    public Object executeJavascript(String javascript) {
        return ((JavascriptExecutor)this.driver).executeScript(javascript, new Object[0]);
    }

    @Override
    public Page getPage() {
        return new SeleniumPage(this.driver);
    }

    @Override
    public String getUrl() {
        return this.driver.getCurrentUrl();
    }

    @Override
    public Dimension getScreenSize() {
        org.openqa.selenium.Dimension windowSize = this.driver.manage().window().getSize();
        return new Dimension(windowSize.getWidth(), windowSize.getHeight());
    }

    @Override
    public void refresh() {
        this.driver.navigate().refresh();
    }
}

