/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.browser;

import com.galenframework.browser.Browser;
import com.galenframework.browser.BrowserFactory;
import com.galenframework.browser.SeleniumBrowser;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumGridBrowserFactory
implements BrowserFactory {
    private String gridUrl;
    private String browser;
    private String browserVersion;
    private Platform platform;
    private Map<String, String> desiredCapabilities = new HashMap<String, String>();

    public SeleniumGridBrowserFactory(String gridUrl) {
        this.setGridUrl(gridUrl);
    }

    @Override
    public Browser openBrowser() {
        try {
            RemoteWebDriver driver = new RemoteWebDriver(new URL(this.gridUrl), (Capabilities)this.createCapabilities());
            WebDriver augmentedDriver = new Augmenter().augment((WebDriver)driver);
            return new SeleniumBrowser(augmentedDriver);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public DesiredCapabilities createCapabilities() {
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
        if (this.platform != null) {
            desiredCapabilities.setPlatform(this.platform);
        }
        if (this.browser != null) {
            desiredCapabilities.setBrowserName(this.browser);
        }
        if (this.browserVersion != null) {
            desiredCapabilities.setVersion(this.browserVersion);
        }
        for (Map.Entry<String, String> dc : this.desiredCapabilities.entrySet()) {
            String value = dc.getValue();
            if ("true".equals(value) || "false".equals(value)) {
                desiredCapabilities.setCapability(dc.getKey(), Boolean.parseBoolean(value));
                continue;
            }
            desiredCapabilities.setCapability(dc.getKey(), value);
        }
        return desiredCapabilities;
    }

    public SeleniumGridBrowserFactory withBrowser(String browser) {
        this.setBrowser(browser);
        return this;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public SeleniumGridBrowserFactory withBrowserVersion(String browserVersion) {
        this.setBrowserVersion(browserVersion);
        return this;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public SeleniumGridBrowserFactory withPlatform(Platform platform) {
        this.setPlatform(platform);
        return this;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public String getGridUrl() {
        return this.gridUrl;
    }

    public void setGridUrl(String gridUrl) {
        this.gridUrl = gridUrl;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.browser).append((Object)this.browserVersion).append((Object)this.gridUrl).append((Object)this.platform).append(this.desiredCapabilities).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("browser", (Object)this.browser).append("browserVersion", (Object)this.browserVersion).append("gridUrl", (Object)this.gridUrl).append("platform", (Object)this.platform).append("desiredCapabilities", this.desiredCapabilities).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SeleniumGridBrowserFactory)) {
            return false;
        }
        SeleniumGridBrowserFactory rhs = (SeleniumGridBrowserFactory)obj;
        return new EqualsBuilder().append((Object)this.browser, (Object)rhs.browser).append((Object)this.browserVersion, (Object)rhs.browserVersion).append((Object)this.gridUrl, (Object)rhs.gridUrl).append((Object)this.platform, (Object)rhs.platform).append(this.desiredCapabilities, this.desiredCapabilities).isEquals();
    }

    public SeleniumGridBrowserFactory withDesiredCapability(String name, String value) {
        this.desiredCapabilities.put(name, value);
        return this;
    }

    public void setDesiredCapabilites(Map<String, String> desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
    }
}

