/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator;

import com.galenframework.generator.raycast.EdgesContainer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AssertionEdge {
    private String object;
    private EdgeType edgeType;

    public AssertionEdge(String object, EdgeType edgeType) {
        this.object = object;
        this.edgeType = edgeType;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public EdgeType getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(EdgeType edgeType) {
        this.edgeType = edgeType;
    }

    public static AssertionEdge left(EdgesContainer.Edge edge) {
        return new AssertionEdge(edge.itemNode.getPageItem().getName(), EdgeType.left);
    }

    public static AssertionEdge right(EdgesContainer.Edge edge) {
        return new AssertionEdge(edge.itemNode.getPageItem().getName(), EdgeType.right);
    }

    public static AssertionEdge top(EdgesContainer.Edge edge) {
        return new AssertionEdge(edge.itemNode.getPageItem().getName(), EdgeType.top);
    }

    public static AssertionEdge bottom(EdgesContainer.Edge edge) {
        return new AssertionEdge(edge.itemNode.getPageItem().getName(), EdgeType.bottom);
    }

    public static AssertionEdge left(String name) {
        return new AssertionEdge(name, EdgeType.left);
    }

    public static AssertionEdge right(String name) {
        return new AssertionEdge(name, EdgeType.right);
    }

    public static AssertionEdge top(String name) {
        return new AssertionEdge(name, EdgeType.top);
    }

    public static AssertionEdge bottom(String name) {
        return new AssertionEdge(name, EdgeType.bottom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssertionEdge that = (AssertionEdge)o;
        return new EqualsBuilder().append((Object)this.object, (Object)that.object).append((Object)this.edgeType, (Object)that.edgeType).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.object).append((Object)this.edgeType).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("object", (Object)this.object).append("edgeType", (Object)this.edgeType).toString();
    }

    public static enum EdgeType {
        left,
        right,
        top,
        bottom;

    }
}

