/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.galenframework.generator.PageItem;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class PageItemNode {
    private final PageItem pageItem;
    private List<PageItemNode> children = new LinkedList<PageItemNode>();
    @JsonIgnore
    private PageItemNode parent = null;
    private int minimalPaddingLeft = -100;
    private int minimalPaddingRight = -100;
    private int minimalPaddingTop = -100;
    private int minimalPaddingBottom = -100;

    public PageItemNode(PageItem pageItem) {
        this.pageItem = pageItem;
    }

    public PageItem getPageItem() {
        return this.pageItem;
    }

    public List<PageItemNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<PageItemNode> children) {
        this.children = children;
    }

    public void moveToParent(PageItemNode pinB) {
        pinB.addChild(this);
        this.parent = pinB;
    }

    private void addChild(PageItemNode pin) {
        if (!this.children.contains(pin)) {
            this.children.add(pin);
        }
        pin.parent = this;
    }

    public void printTree() {
        this.printTree("");
    }

    private void printTree(String indentation) {
        System.out.print(indentation);
        System.out.println(this.pageItem.getName());
        for (PageItemNode childPin : this.children) {
            childPin.printTree(indentation + "    ");
        }
    }

    public PageItemNode getParent() {
        return this.parent;
    }

    public void visitTree(Consumer<PageItemNode> consumer) {
        consumer.accept(this);
        for (PageItemNode pin : this.children) {
            pin.visitTree(consumer);
        }
    }

    public int getMinimalPaddingLeft() {
        return this.minimalPaddingLeft;
    }

    public void updateMinimalPaddingLeft(int padding) {
        this.minimalPaddingLeft = this.smallestValue(this.minimalPaddingLeft, padding);
    }

    public int getMinimalPaddingRight() {
        return this.minimalPaddingRight;
    }

    public void updateMinimalPaddingRight(int padding) {
        this.minimalPaddingRight = this.smallestValue(this.minimalPaddingRight, padding);
    }

    public int getMinimalPaddingTop() {
        return this.minimalPaddingTop;
    }

    public void updateMinimalPaddingTop(int padding) {
        this.minimalPaddingTop = this.smallestValue(this.minimalPaddingTop, padding);
    }

    public int getMinimalPaddingBottom() {
        return this.minimalPaddingBottom;
    }

    public void updateMinimalPaddingBottom(int padding) {
        this.minimalPaddingBottom = this.smallestValue(this.minimalPaddingBottom, padding);
    }

    private int smallestValue(int original, int newValue) {
        if (original < 0 || original > newValue) {
            return newValue;
        }
        return original;
    }

    public PageItemNode findParentOrSelf() {
        return this.parent != null ? this.parent : this;
    }
}

