/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator;

import com.galenframework.generator.PageItemNode;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.SuggestionOptions;
import com.galenframework.generator.SuggestionTestResult;
import com.galenframework.generator.builders.CompositeSpecBuilder;
import com.galenframework.generator.builders.SpecBuilderAbove;
import com.galenframework.generator.builders.SpecBuilderBelow;
import com.galenframework.generator.builders.SpecBuilderInside;
import com.galenframework.generator.builders.SpecBuilderLeftOf;
import com.galenframework.generator.builders.SpecBuilderRightOf;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.filters.SpecFilter;
import com.galenframework.generator.raycast.EdgesContainer;
import com.galenframework.generator.suggestions.CenteredInsideSpecSuggestion;
import com.galenframework.generator.suggestions.HAlignSpecSuggestion;
import com.galenframework.generator.suggestions.RuleHAlignSpecSuggestion;
import com.galenframework.generator.suggestions.RuleVAlignSpecSuggestion;
import com.galenframework.generator.suggestions.SizeSpecSuggestion;
import com.galenframework.generator.suggestions.SpecSuggestion;
import com.galenframework.generator.suggestions.VAlignSpecSuggestion;
import com.galenframework.page.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class SpecSuggester {
    public static List<SpecSuggestion> horizontallyOrderComplexRulesSuggestions = new ArrayList<SpecSuggestion>(){
        {
            this.add(new RuleHAlignSpecSuggestion());
        }
    };
    public static List<SpecSuggestion> verticallyOrderComplexRulesSuggestions = new ArrayList<SpecSuggestion>(){
        {
            this.add(new RuleVAlignSpecSuggestion());
        }
    };
    public static List<SpecSuggestion> horizontallyOrderSuggestions = new ArrayList<SpecSuggestion>(){
        {
            this.add(new HAlignSpecSuggestion());
        }
    };
    public static List<SpecSuggestion> verticallyOrderSuggestions = new ArrayList<SpecSuggestion>(){
        {
            this.add(new VAlignSpecSuggestion());
        }
    };
    public static List<SpecSuggestion> singleItemSuggestions = new ArrayList<SpecSuggestion>(){
        {
            this.add(new SizeSpecSuggestion());
        }
    };
    public static List<SpecSuggestion> parentSuggestions = new ArrayList<SpecSuggestion>(){
        {
            this.add(new CenteredInsideSpecSuggestion());
        }
    };
    private final SuggestionOptions options;
    List<SpecFilter> excludedFilters = new LinkedList<SpecFilter>();

    public SpecSuggester(SuggestionOptions options) {
        this.options = options;
    }

    public SuggestionTestResult suggestSpecsForMultipleObjects(List<PageItemNode> pins, List<SpecSuggestion> suggestions, SpecGeneratorOptions specGeneratorOptions) {
        SuggestionTestResult globalResult = new SuggestionTestResult();
        List<PageItemNode[]> pinsVariations = this.generateSequentialVariations(pins.toArray(new PageItemNode[pins.size()]));
        for (PageItemNode[] pinsVariation : pinsVariations) {
            String[] namesArray = (String[])Arrays.stream(pinsVariation).map(p -> p.getPageItem().getName()).toArray(String[]::new);
            for (SpecSuggestion suggestion : suggestions) {
                if (this.matchesExcludedFilter(suggestion.getName(), namesArray)) continue;
                SuggestionTestResult result = suggestion.test(this.options, specGeneratorOptions, pinsVariation);
                globalResult.merge(result);
                if (result == null || !result.isValid() || result.getFilters() == null) continue;
                this.excludedFilters.addAll(result.getFilters());
            }
        }
        return globalResult;
    }

    private List<PageItemNode[]> generateSequentialVariations(PageItemNode[] pageItemNodes) {
        LinkedList<PageItemNode[]> variations = new LinkedList<PageItemNode[]>();
        if (pageItemNodes != null && pageItemNodes.length > 1) {
            variations.add(pageItemNodes);
        }
        for (int amount = pageItemNodes.length - 1; amount > 1; --amount) {
            for (int offset = 0; offset <= pageItemNodes.length - amount; ++offset) {
                PageItemNode[] variation = new PageItemNode[amount];
                for (int i = 0; i < amount; ++i) {
                    variation[i] = pageItemNodes[offset + i];
                }
                variations.add(variation);
            }
        }
        return variations;
    }

    public SuggestionTestResult suggestSpecsForTwoObjects(List<PageItemNode> pins, List<SpecSuggestion> suggestions, SpecGeneratorOptions specGeneratorOptions) {
        SuggestionTestResult globalResult = new SuggestionTestResult();
        for (int i = 0; i < pins.size() - 1; ++i) {
            for (int j = i + 1; j < pins.size(); ++j) {
                for (SpecSuggestion suggestion : suggestions) {
                    if (this.matchesExcludedFilter(suggestion.getName(), pins.get(i).getPageItem().getName(), pins.get(j).getPageItem().getName())) continue;
                    SuggestionTestResult result = suggestion.test(this.options, specGeneratorOptions, pins.get(i), pins.get(j));
                    globalResult.merge(result);
                    if (result == null || !result.isValid() || result.getFilters() == null) continue;
                    this.excludedFilters.addAll(result.getFilters());
                }
            }
        }
        return globalResult;
    }

    public SuggestionTestResult suggestSpecsForSingleObject(List<PageItemNode> pins, List<SpecSuggestion> suggestions, SpecGeneratorOptions specGeneratorOptions) {
        SuggestionTestResult globalResult = new SuggestionTestResult();
        for (PageItemNode pin : pins) {
            for (SpecSuggestion suggestion : suggestions) {
                if (this.matchesExcludedFilter(suggestion.getName(), pin.getPageItem().getName())) continue;
                SuggestionTestResult result = suggestion.test(this.options, specGeneratorOptions, pin);
                globalResult.merge(result);
                if (result == null || !result.isValid() || result.getFilters() == null) continue;
                this.excludedFilters.addAll(result.getFilters());
            }
        }
        return globalResult;
    }

    public SuggestionTestResult suggestSpecsRayCasting(PageItemNode parent, List<PageItemNode> pins, SpecGeneratorOptions specGeneratorOptions) {
        SuggestionTestResult globalResult = new SuggestionTestResult();
        EdgesContainer edges = EdgesContainer.create(parent, pins);
        HashMap<String, CompositeSpecBuilder> allSpecBuilders = new HashMap<String, CompositeSpecBuilder>();
        for (PageItemNode pin : pins) {
            Point[] points = pin.getPageItem().getArea().getPoints();
            EdgesContainer.Edge closestRightEdge = this.rayCastRight(pin, new EdgesContainer.Edge(pin, points[1], points[2]), edges.getRightEdges());
            EdgesContainer.Edge closestLeftEdge = this.rayCastLeft(pin, new EdgesContainer.Edge(pin, points[0], points[3]), edges.getLeftEdges());
            EdgesContainer.Edge closestBottomEdge = this.rayCastBottom(pin, new EdgesContainer.Edge(pin, points[3], points[2]), edges.getBottomEdges());
            EdgesContainer.Edge closestTopEdge = this.rayCastTop(pin, new EdgesContainer.Edge(pin, points[0], points[1]), edges.getTopEdges());
            CompositeSpecBuilder compositeSpecBuilder = new CompositeSpecBuilder();
            allSpecBuilders.put(pin.getPageItem().getName(), compositeSpecBuilder);
            SpecBuilderInside sbInside = new SpecBuilderInside(pin, pin.getParent());
            compositeSpecBuilder.add(sbInside);
            if (closestRightEdge != null) {
                if (closestRightEdge.itemNode == pin.getParent()) {
                    closestRightEdge.itemNode.updateMinimalPaddingRight(closestRightEdge.p1.getLeft() - points[1].getLeft());
                    sbInside.addRightEdge();
                } else {
                    compositeSpecBuilder.add(new SpecBuilderLeftOf(pin.getPageItem(), closestRightEdge));
                }
            }
            if (closestLeftEdge != null) {
                if (closestLeftEdge.itemNode == pin.getParent()) {
                    closestLeftEdge.itemNode.updateMinimalPaddingLeft(points[0].getLeft() - closestLeftEdge.p1.getLeft());
                    sbInside.addLeftEdge();
                } else {
                    compositeSpecBuilder.add(new SpecBuilderRightOf(pin.getPageItem(), closestLeftEdge));
                }
            }
            if (closestBottomEdge != null) {
                if (closestBottomEdge.itemNode == pin.getParent()) {
                    closestBottomEdge.itemNode.updateMinimalPaddingBottom(closestBottomEdge.p1.getTop() - points[3].getTop());
                    sbInside.addBottomEdge();
                } else {
                    compositeSpecBuilder.add(new SpecBuilderAbove(pin.getPageItem(), closestBottomEdge));
                }
            }
            if (closestTopEdge == null) continue;
            if (closestTopEdge.itemNode == pin.getParent()) {
                closestTopEdge.itemNode.updateMinimalPaddingTop(points[0].getTop() - closestTopEdge.p1.getTop());
                sbInside.addTopEdge();
                continue;
            }
            compositeSpecBuilder.add(new SpecBuilderBelow(pin.getPageItem(), closestTopEdge));
        }
        HashMap<String, List<SpecStatement>> objectSpecs = new HashMap<String, List<SpecStatement>>();
        allSpecBuilders.forEach((itemName, specBuilder) -> {
            List<SpecStatement> specs = specBuilder.buildSpecs(this.excludedFilters, specGeneratorOptions);
            if (specs != null && !specs.isEmpty()) {
                objectSpecs.put((String)itemName, specs);
            }
        });
        globalResult.setGeneratedObjectSpecs(objectSpecs);
        return globalResult;
    }

    private EdgesContainer.Edge rayCastTop(PageItemNode pin, EdgesContainer.Edge edge, List<EdgesContainer.Edge> edges) {
        return this.findClosestEdge(pin, edges, otherEdge -> {
            if (otherEdge.isInTopZoneOf(edge)) {
                return edge.p1.getTop() - otherEdge.p1.getTop();
            }
            return -1;
        });
    }

    private EdgesContainer.Edge rayCastBottom(PageItemNode pin, EdgesContainer.Edge edge, List<EdgesContainer.Edge> edges) {
        return this.findClosestEdge(pin, edges, otherEdge -> {
            if (otherEdge.isInBottomZoneOf(edge)) {
                return otherEdge.p1.getTop() - edge.p1.getTop();
            }
            return -1;
        });
    }

    private EdgesContainer.Edge rayCastRight(PageItemNode pin, EdgesContainer.Edge edge, List<EdgesContainer.Edge> edges) {
        return this.findClosestEdge(pin, edges, otherEdge -> {
            if (otherEdge.isInRightZoneOf(edge)) {
                return otherEdge.p1.getLeft() - edge.p1.getLeft();
            }
            return -1;
        });
    }

    private EdgesContainer.Edge rayCastLeft(PageItemNode pin, EdgesContainer.Edge edge, List<EdgesContainer.Edge> edges) {
        return this.findClosestEdge(pin, edges, otherEdge -> {
            if (otherEdge.isInLeftZoneOf(edge)) {
                return edge.p1.getLeft() - otherEdge.p1.getLeft();
            }
            return -1;
        });
    }

    private EdgesContainer.Edge findClosestEdge(PageItemNode pin, List<EdgesContainer.Edge> otherEdges, Function<EdgesContainer.Edge, Integer> distanceCalculator) {
        EdgesContainer.Edge closestEdge = null;
        int distance = 1000000;
        for (EdgesContainer.Edge otherEdge : otherEdges) {
            int d;
            if (otherEdge.itemNode == pin || (d = distanceCalculator.apply(otherEdge).intValue()) < 0 || distance <= d) continue;
            distance = d;
            closestEdge = otherEdge;
        }
        return closestEdge;
    }

    private boolean matchesExcludedFilter(String suggestionId, String ... args) {
        for (SpecFilter specFilter : this.excludedFilters) {
            if (!specFilter.matches(suggestionId, args)) continue;
            return true;
        }
        return false;
    }
}

