/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.builders;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.PageItem;
import com.galenframework.generator.SpecAssertion;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.builders.AbstractSpecBuilder;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.filters.SpecFilter;
import com.galenframework.generator.raycast.EdgesContainer;
import java.util.Collections;
import java.util.List;

public class SpecBuilderAbove
extends AbstractSpecBuilder {
    public static final String S_ABOVE = "s_above";
    private final PageItem pageItem;
    private final EdgesContainer.Edge bottomEdge;

    public SpecBuilderAbove(PageItem pageItem, EdgesContainer.Edge bottomEdge) {
        this.pageItem = pageItem;
        this.bottomEdge = bottomEdge;
    }

    @Override
    public List<SpecStatement> buildSpecs(List<SpecFilter> excludedFilters, SpecGeneratorOptions options) {
        StringBuilder s = new StringBuilder("above ");
        s.append(this.bottomEdge.itemNode.getPageItem().getName());
        int distance = this.bottomEdge.p1.getTop() - this.pageItem.getArea().getBottom();
        if (distance <= options.getMinimalStickyVerticalDistance()) {
            s.append(' ').append(distance).append("px");
        }
        this.extendSpecFilters(excludedFilters, "s_below");
        return Collections.singletonList(new SpecStatement(s.toString(), Collections.singletonList(new SpecAssertion(AssertionEdge.bottom(this.pageItem.getName()), AssertionEdge.top(this.bottomEdge)))));
    }

    @Override
    public String getName() {
        return S_ABOVE;
    }

    @Override
    public String[] getArgs() {
        return new String[]{this.pageItem.getName(), this.bottomEdge.itemNode.getPageItem().getName()};
    }
}

