/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.builders;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.PageItemNode;
import com.galenframework.generator.SpecAssertion;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.builders.SBIEdge;
import com.galenframework.generator.builders.SBIEdgeResult;
import com.galenframework.generator.builders.SpecBuilder;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.filters.SpecFilter;
import com.galenframework.page.Point;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SpecBuilderInside
implements SpecBuilder {
    public static final String S_INSIDE = "s_inside";
    private final Point[] points;
    private final PageItemNode parent;
    private final PageItemNode itemNode;
    private List<SBIEdge> sbiEdges = new LinkedList<SBIEdge>();

    public SpecBuilderInside(PageItemNode itemNode, PageItemNode parent) {
        this.itemNode = itemNode;
        this.points = itemNode.getPageItem().getArea().getPoints();
        this.parent = parent;
    }

    @Override
    public String getName() {
        return S_INSIDE;
    }

    @Override
    public String[] getArgs() {
        return new String[]{this.itemNode.getPageItem().getName(), this.parent.getPageItem().getName()};
    }

    @Override
    public List<SpecStatement> buildSpecs(List<SpecFilter> excludedFilters, SpecGeneratorOptions options) {
        LinkedList<SpecAssertion> assertions = new LinkedList<SpecAssertion>();
        boolean isPartly = false;
        for (Point p : this.points) {
            int offset = this.parent.getPageItem().getArea().calculatePointOffsetDistance(p);
            if (offset <= 0) continue;
            isPartly = true;
        }
        StringBuilder s = new StringBuilder("inside ");
        if (isPartly) {
            s.append("partly ");
        }
        s.append(this.parent.getPageItem().getName());
        if (!this.sbiEdges.isEmpty()) {
            s.append(" ");
            boolean[] isFirst = new boolean[]{true};
            Collections.sort(this.sbiEdges, (a, b) -> a.order > b.order ? 1 : -1);
            Stream<SBIEdgeResult> resultStream = this.sbiEdges.stream().map(se -> se.build(this.parent, this.points, options));
            if (!isPartly) {
                resultStream = resultStream.filter(r -> r.isRedundant == false);
            }
            List<Pair> groupedResults = resultStream.collect(Collectors.groupingBy(r -> r.validation, Collectors.toList())).entrySet().stream().map(e -> new ImmutablePair(e.getKey(), e.getValue())).collect(Collectors.toList());
            Collections.sort(groupedResults, (a, b) -> ((String)a.getKey()).startsWith(">") ? 1 : -1);
            groupedResults.forEach(pair -> {
                if (!isFirst[0]) {
                    s.append(", ");
                }
                s.append((String)pair.getKey());
                for (SBIEdgeResult result : (List)pair.getValue()) {
                    s.append(' ').append(result.edgeName);
                    assertions.add(new SpecAssertion(new AssertionEdge(this.itemNode.getPageItem().getName(), result.assertionEdge.getEdgeType()), result.assertionEdge));
                }
                blArray[0] = false;
            });
        }
        return Collections.singletonList(new SpecStatement(s.toString().trim(), assertions));
    }

    public SpecBuilderInside addRightEdge() {
        this.sbiEdges.add(SBIEdge.RIGHT);
        return this;
    }

    public SpecBuilderInside addLeftEdge() {
        this.sbiEdges.add(SBIEdge.LEFT);
        return this;
    }

    public SpecBuilderInside addBottomEdge() {
        this.sbiEdges.add(SBIEdge.BOTTOM);
        return this;
    }

    public SpecBuilderInside addTopEdge() {
        this.sbiEdges.add(SBIEdge.TOP);
        return this;
    }
}

