/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.builders;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.PageItem;
import com.galenframework.generator.SpecAssertion;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.builders.AbstractSpecBuilder;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.filters.SpecFilter;
import com.galenframework.generator.raycast.EdgesContainer;
import java.util.Collections;
import java.util.List;

public class SpecBuilderLeftOf
extends AbstractSpecBuilder {
    public static final String S_LEFT_OF = "s_left_of";
    private final PageItem pageItem;
    private final EdgesContainer.Edge rightEdge;

    public SpecBuilderLeftOf(PageItem pageItem, EdgesContainer.Edge rightEdge) {
        this.pageItem = pageItem;
        this.rightEdge = rightEdge;
    }

    @Override
    public List<SpecStatement> buildSpecs(List<SpecFilter> excludedFilters, SpecGeneratorOptions options) {
        StringBuilder s = new StringBuilder("left-of ");
        s.append(this.rightEdge.itemNode.getPageItem().getName());
        int distance = this.rightEdge.p1.getLeft() - this.pageItem.getArea().getRight();
        if (distance <= options.getMinimalStickyHorizontalDistance()) {
            s.append(' ').append(distance).append("px");
        }
        this.extendSpecFilters(excludedFilters, "s_right_of");
        return Collections.singletonList(new SpecStatement(s.toString(), Collections.singletonList(new SpecAssertion(AssertionEdge.right(this.pageItem.getName()), AssertionEdge.left(this.rightEdge)))));
    }

    @Override
    public String getName() {
        return S_LEFT_OF;
    }

    @Override
    public String[] getArgs() {
        return new String[]{this.pageItem.getName(), this.rightEdge.itemNode.getPageItem().getName()};
    }
}

