/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.model;

import com.galenframework.generator.model.GmObjectSpecs;
import com.galenframework.generator.model.GmSpec;
import com.galenframework.generator.model.GmSpecRule;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GmPageSection {
    private String name;
    private List<GmSpecRule> rules = new LinkedList<GmSpecRule>();
    private List<GmObjectSpecs> objectSpecs = new LinkedList<GmObjectSpecs>();

    public GmPageSection optimizeSection() {
        GmPageSection section = new GmPageSection(this.name);
        section.setRules(this.rules);
        Map<String, List<String>> specsMap = this.groupBySpecs();
        HashMap<String, List> regroupedSpecs = new HashMap<String, List>();
        specsMap.forEach((spec, objects) -> {
            String objectNames = StringUtils.join((Iterable)objects, (String)", ");
            LinkedList<GmSpec> specs = (LinkedList<GmSpec>)regroupedSpecs.get(objectNames);
            if (specs == null) {
                specs = new LinkedList<GmSpec>();
                regroupedSpecs.put(objectNames, specs);
            }
            specs.add(new GmSpec((String)spec));
        });
        regroupedSpecs.forEach((name, specs) -> section.getObjectSpecs().add(new GmObjectSpecs((String)name, (List<GmSpec>)specs)));
        section.getObjectSpecs().forEach(os -> Collections.sort(os.getSpecs(), this.bySpecText()));
        return section;
    }

    private Comparator<GmSpec> bySpecText() {
        return (a, b) -> a.getStatement().compareTo(b.getStatement());
    }

    private Map<String, List<String>> groupBySpecs() {
        HashMap<String, List<String>> specsMap = new HashMap<String, List<String>>();
        this.objectSpecs.forEach(object -> object.getSpecs().forEach(spec -> {
            LinkedList<String> objectsPerSpec = (LinkedList<String>)specsMap.get(spec.getStatement());
            if (objectsPerSpec == null) {
                objectsPerSpec = new LinkedList<String>();
                specsMap.put(spec.getStatement(), objectsPerSpec);
            }
            if (!objectsPerSpec.contains(object.getObjectName())) {
                objectsPerSpec.add(object.getObjectName());
            }
        }));
        return specsMap;
    }

    public GmPageSection(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<GmSpecRule> getRules() {
        return this.rules;
    }

    public void setRules(List<GmSpecRule> rules) {
        this.rules = rules;
    }

    public List<GmObjectSpecs> getObjectSpecs() {
        return this.objectSpecs;
    }

    public void setObjectSpecs(List<GmObjectSpecs> objectSpecs) {
        this.objectSpecs = objectSpecs;
    }

    public boolean getHasContent() {
        return this.getHasRules() || this.objectSpecs != null && !this.objectSpecs.isEmpty();
    }

    public boolean getHasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }
}

