/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.suggestions;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.PageItemNode;
import com.galenframework.generator.SpecAssertion;
import com.galenframework.generator.SpecGeneratorUtils;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.SuggestionOptions;
import com.galenframework.generator.SuggestionTestResult;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.suggestions.SpecSuggestion;
import com.galenframework.page.Rect;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractRuleAlignSpecSuggestion
implements SpecSuggestion {
    @Override
    public SuggestionTestResult test(SuggestionOptions options, SpecGeneratorOptions specGeneratorOptions, PageItemNode ... pins) {
        HashSet<Integer> diffs = new HashSet<Integer>();
        int previousDiff = 0;
        if (pins != null && pins.length > 1) {
            for (int i = 0; i < pins.length - 1; ++i) {
                Rect area2;
                Rect area1 = pins[i].getPageItem().getArea();
                if (this.areAligned(area1, area2 = pins[i + 1].getPageItem().getArea())) {
                    return null;
                }
                int diff = this.calculateDiff(area1, area2);
                if (diff > 70) {
                    return null;
                }
                if (!diffs.isEmpty() && Math.abs(previousDiff - diff) > 3) {
                    return null;
                }
                diffs.add(diff);
                previousDiff = diff;
            }
            String rule = null;
            if (diffs.size() == 1) {
                rule = String.format("| %s are aligned " + this.getAlignmentWay() + " with %dpx margin", this.constructNames(options, pins), diffs.iterator().next());
            } else if (diffs.size() > 1) {
                rule = String.format("| %s are aligned " + this.getAlignmentWay() + " with ~%dpx margin", this.constructNames(options, pins), this.findAverageDiff(diffs));
            }
            if (rule != null) {
                List<String> filterArgs = Arrays.stream(pins).map(p -> p.getPageItem().getName()).collect(Collectors.toList());
                return this.enrichWithFilters(new SuggestionTestResult().addGeneratedRule(pins[0].getPageItem().getName(), new SpecStatement(rule, this.createAssertions(pins))), filterArgs);
            }
        }
        return null;
    }

    protected List<SpecAssertion> createAssertions(PageItemNode[] pins) {
        LinkedList<SpecAssertion> assertions = new LinkedList<SpecAssertion>();
        for (int i = 0; i < pins.length - 1; ++i) {
            assertions.add(new SpecAssertion(new AssertionEdge(pins[i].getPageItem().getName(), this.previousEdgeType()), new AssertionEdge(pins[i + 1].getPageItem().getName(), this.nextEdgeType())));
        }
        return assertions;
    }

    protected abstract AssertionEdge.EdgeType nextEdgeType();

    protected abstract AssertionEdge.EdgeType previousEdgeType();

    protected abstract String getAlignmentWay();

    protected abstract SuggestionTestResult enrichWithFilters(SuggestionTestResult var1, List<String> var2);

    protected abstract int calculateDiff(Rect var1, Rect var2);

    protected abstract boolean areAligned(Rect var1, Rect var2);

    private int findAverageDiff(Set<Integer> diffs) {
        int sum = 0;
        for (Integer diff : diffs) {
            sum += diff.intValue();
        }
        return sum / diffs.size();
    }

    private String constructNames(SuggestionOptions options, PageItemNode[] pins) {
        String pattern = SpecGeneratorUtils.findNamingPattern(options.getAllObjectNames(), pins);
        if (pattern != null) {
            return pattern;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (PageItemNode pin : pins) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(pin.getPageItem().getName());
            first = false;
        }
        return builder.toString();
    }
}

