/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.suggestions;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.SuggestionTestResult;
import com.galenframework.generator.filters.AnyTwoArgsSpecFilter;
import com.galenframework.generator.suggestions.AbstractRuleAlignSpecSuggestion;
import com.galenframework.page.Rect;
import java.util.List;

public class RuleVAlignSpecSuggestion
extends AbstractRuleAlignSpecSuggestion {
    public static final String R_V_ALIGN = "r_v_align";

    @Override
    public String getName() {
        return R_V_ALIGN;
    }

    @Override
    protected AssertionEdge.EdgeType nextEdgeType() {
        return AssertionEdge.EdgeType.top;
    }

    @Override
    protected AssertionEdge.EdgeType previousEdgeType() {
        return AssertionEdge.EdgeType.bottom;
    }

    @Override
    protected String getAlignmentWay() {
        return "vertically above each other";
    }

    @Override
    protected SuggestionTestResult enrichWithFilters(SuggestionTestResult suggestionTestResult, List<String> filterArgs) {
        return suggestionTestResult.addFilter(new AnyTwoArgsSpecFilter(R_V_ALIGN, filterArgs)).addFilter(new AnyTwoArgsSpecFilter("s_above", filterArgs)).addFilter(new AnyTwoArgsSpecFilter("s_below", filterArgs)).addFilter(new AnyTwoArgsSpecFilter("s_v_align", filterArgs)).addFilter(new AnyTwoArgsSpecFilter("s_centered_inside", filterArgs));
    }

    @Override
    protected int calculateDiff(Rect area1, Rect area2) {
        return area2.getTop() - area1.getBottom();
    }

    @Override
    protected boolean areAligned(Rect area1, Rect area2) {
        return area1.getLeft() != area2.getLeft() || area1.getRight() != area2.getRight();
    }
}

