/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.page.selenium;

import com.galenframework.specs.page.Locator;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByChain {
    private final By by;
    private final int index;
    private final ByChain next;

    public ByChain(By by, int index, ByChain next) {
        this.by = by;
        this.index = index;
        this.next = next;
    }

    public List<WebElement> findElements(SearchContext searchContext) {
        List elements = searchContext.findElements(this.by);
        if (this.next != null) {
            if (this.index > 0) {
                if (this.index <= elements.size()) {
                    return this.next.findElements((SearchContext)elements.get(this.index - 1));
                }
                return Collections.emptyList();
            }
            if (elements.size() > 0) {
                return this.next.findElements((SearchContext)elements.get(0));
            }
            return Collections.emptyList();
        }
        return elements;
    }

    public WebElement findElement(SearchContext searchContext) {
        List elements = searchContext.findElements(this.by);
        if (this.next != null) {
            if (this.index > 0) {
                if (this.index <= elements.size()) {
                    return this.next.findElement((SearchContext)elements.get(this.index - 1));
                }
            } else if (elements.size() > 0) {
                return this.next.findElement((SearchContext)elements.get(0));
            }
        } else if (this.index > 0) {
            if (this.index <= elements.size()) {
                return (WebElement)elements.get(this.index - 1);
            }
        } else if (elements.size() > 0) {
            return (WebElement)elements.get(0);
        }
        throw new NoSuchElementException(this.by.toString() + " | index " + this.index);
    }

    public static ByChain fromLocator(Locator locator) {
        return ByChain.fromLocator(locator, null);
    }

    private static ByChain fromLocator(Locator locator, ByChain nextChain) {
        if (locator == null) {
            throw new IllegalArgumentException("Locator shouldn't be null");
        }
        ByChain byChain = new ByChain(ByChain.convertToBy(locator), locator.getIndex(), nextChain);
        if (locator.getParent() != null) {
            byChain = ByChain.fromLocator(locator.getParent(), byChain);
        }
        return byChain;
    }

    private static By convertToBy(Locator locator) {
        if ("xpath".equals(locator.getLocatorType())) {
            return By.xpath((String)locator.getLocatorValue());
        }
        if ("id".equals(locator.getLocatorType())) {
            return By.id((String)locator.getLocatorValue());
        }
        if ("css".equals(locator.getLocatorType())) {
            return By.cssSelector((String)locator.getLocatorValue());
        }
        return null;
    }
}

