/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.page.selenium;

import com.galenframework.config.GalenConfig;
import com.galenframework.config.GalenProperty;
import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.page.selenium.AreaFinder;
import com.galenframework.specs.page.CorrectionsRect;
import com.galenframework.specs.page.Locator;
import java.util.Locale;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebPageElement
extends PageElement {
    private WebDriver driver;
    private WebElement webElement;
    private Locator locator;
    private String objectName;
    private Rect cachedArea = null;

    public WebPageElement(WebDriver driver, String objectName, WebElement webElement, Locator objectLocator) {
        this.driver = driver;
        this.setObjectName(objectName);
        this.setWebElement(webElement);
        this.setLocator(objectLocator);
    }

    @Override
    public Rect calculateArea() {
        if (this.cachedArea == null) {
            this.cachedArea = this.getAreaFinder().findArea(this);
            if (this.getLocator() != null && this.getLocator().getCorrections() != null) {
                this.cachedArea = this.correctedRect(this.cachedArea, this.getLocator().getCorrections());
            }
        }
        return this.cachedArea;
    }

    private AreaFinder getAreaFinder() {
        String areaFinderName = GalenConfig.getConfig().getStringProperty(GalenProperty.GALEN_BROWSER_PAGELEMENT_AREAFINDER);
        return AreaFinder.valueOf(areaFinderName.toUpperCase(Locale.ENGLISH));
    }

    private Rect correctedRect(Rect rect, CorrectionsRect corrections) {
        return new Rect(corrections.getLeft().correct(rect.getLeft()), corrections.getTop().correct(rect.getTop()), corrections.getWidth().correct(rect.getWidth()), corrections.getHeight().correct(rect.getHeight()));
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean isVisible() {
        try {
            return this.getWebElement().isDisplayed();
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
    }

    @Override
    public int getWidth() {
        return this.getArea().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getArea().getHeight();
    }

    @Override
    public int getLeft() {
        return this.getArea().getLeft();
    }

    @Override
    public int getTop() {
        return this.getArea().getTop();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public WebElement getWebElement() {
        return this.webElement;
    }

    public void setWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    @Override
    public String getText() {
        WebElement webElement = this.getWebElement();
        if ("input".equals(webElement.getTagName().toLowerCase())) {
            String value = webElement.getAttribute("value");
            if (value == null) {
                value = "";
            }
            return value;
        }
        return this.getWebElement().getText().trim();
    }

    @Override
    public String getCssProperty(String cssPropertyName) {
        return this.getWebElement().getCssValue(cssPropertyName);
    }

    public WebDriver getDriver() {
        return this.driver;
    }
}

