/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.StringCharReader;
import java.util.Comparator;

public class AlphanumericComparator
implements Comparator<String> {
    @Override
    public int compare(String left, String right) {
        StringCharReader leftReader = new StringCharReader(left);
        StringCharReader rightReader = new StringCharReader(right);
        while (leftReader.hasMore() && rightReader.hasMore()) {
            int result;
            String leftChunk = this.parseChunk(leftReader);
            String rightChunk = this.parseChunk(rightReader);
            if (!(this.firstLetterIsDigit(leftChunk) && this.firstLetterIsDigit(rightChunk) ? (result = this.toInt(leftChunk) - this.toInt(rightChunk)) != 0 : (result = leftChunk.compareTo(rightChunk)) != 0)) continue;
            return result;
        }
        return left.length() - right.length();
    }

    private boolean firstLetterIsDigit(String chunk) {
        return chunk.length() > 0 && this.isDigit(chunk.charAt(0));
    }

    private Integer toInt(String chunk) {
        return Integer.parseInt(chunk);
    }

    private String parseChunk(StringCharReader reader) {
        if (this.isDigit(reader.currentSymbol())) {
            return this.parseNumber(reader);
        }
        return this.parseNonNumber(reader);
    }

    private String parseNonNumber(StringCharReader reader) {
        StringBuilder builder = new StringBuilder();
        while (reader.hasMore() && !this.isDigit(reader.currentSymbol())) {
            builder.append(reader.next());
        }
        return builder.toString();
    }

    private String parseNumber(StringCharReader reader) {
        StringBuilder builder = new StringBuilder();
        while (reader.hasMore() && this.isDigit(reader.currentSymbol())) {
            builder.append(reader.next());
        }
        return builder.toString();
    }

    private boolean isDigit(char symbol) {
        return symbol >= '0' && symbol <= '9';
    }
}

