/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.ExpectRange;
import com.galenframework.parser.Expectation;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.rainbow4j.colorscheme.ColorClassifier;
import com.galenframework.rainbow4j.colorscheme.GradientColorClassifier;
import com.galenframework.rainbow4j.colorscheme.SimpleColorClassifier;
import com.galenframework.specs.Range;
import com.galenframework.specs.colors.ColorRange;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExpectColorRanges
implements Expectation<List<ColorRange>> {
    private static Map<String, Color> colorWords = new HashMap<String, Color>(){
        {
            this.put("black", Color.black);
            this.put("white", Color.white);
            this.put("gray", Color.gray);
            this.put("red", Color.red);
            this.put("orange", Color.orange);
            this.put("pink", Color.pink);
            this.put("green", Color.green);
            this.put("blue", Color.blue);
            this.put("yellow", Color.yellow);
            this.put("magenta", Color.magenta);
            this.put("cyan", Color.cyan);
        }
    };

    @Override
    public List<ColorRange> read(StringCharReader reader) {
        ExpectRange expectRange = new ExpectRange();
        expectRange.setEndingWord("%");
        LinkedList<ColorRange> colorRanges = new LinkedList<ColorRange>();
        while (reader.hasMore()) {
            Range range = expectRange.read(reader);
            String colorText = reader.readSafeUntilSymbol(',').trim();
            if (colorText.isEmpty()) {
                throw new SyntaxException("No color defined");
            }
            ColorClassifier colorClassifier = ExpectColorRanges.parseColorClassifier(colorText);
            colorRanges.add(new ColorRange(colorText, colorClassifier, range));
        }
        return colorRanges;
    }

    public static ColorClassifier parseColorClassifier(String colorText) {
        if (colorText.contains("-")) {
            return ExpectColorRanges.parseGradientClassifier(colorText);
        }
        Color color = ExpectColorRanges.parseColor(colorText);
        return new SimpleColorClassifier(colorText, color);
    }

    public static GradientColorClassifier parseGradientClassifier(String colorText) {
        List colors = Arrays.asList(colorText.split("-")).stream().map(String::trim).filter(text -> !text.isEmpty()).map(ExpectColorRanges::parseColor).collect(Collectors.toList());
        return new GradientColorClassifier(colorText, colors);
    }

    public static Color parseColor(String colorText) {
        if (colorText.startsWith("#")) {
            if (colorText.length() == 4) {
                return Color.decode(ExpectColorRanges.convertShortHandNotation(colorText));
            }
            return Color.decode(colorText);
        }
        if (colorWords.containsKey(colorText)) {
            return colorWords.get(colorText);
        }
        throw new SyntaxException("Unknown color: " + colorText);
    }

    private static String convertShortHandNotation(String colorText) {
        char r = colorText.charAt(1);
        char g = colorText.charAt(2);
        char b = colorText.charAt(3);
        return "#" + r + r + g + g + b + b;
    }
}

