/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.ExpectWord;
import com.galenframework.parser.Expectation;
import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ExpectCommaSeparatedKeyValue
implements Expectation<List<Pair<String, String>>> {
    private final Integer SQUARE_BRACKET = 1;
    private final Integer CURLY_BRACKET = 2;
    private final Integer ROUND_BRACKET = 3;
    private Map<Character, Integer> bracketsToType = new HashMap<Character, Integer>(){
        {
            this.put(Character.valueOf('['), ExpectCommaSeparatedKeyValue.this.SQUARE_BRACKET);
            this.put(Character.valueOf(']'), ExpectCommaSeparatedKeyValue.this.SQUARE_BRACKET);
            this.put(Character.valueOf('('), ExpectCommaSeparatedKeyValue.this.ROUND_BRACKET);
            this.put(Character.valueOf(')'), ExpectCommaSeparatedKeyValue.this.ROUND_BRACKET);
            this.put(Character.valueOf('{'), ExpectCommaSeparatedKeyValue.this.CURLY_BRACKET);
            this.put(Character.valueOf('}'), ExpectCommaSeparatedKeyValue.this.CURLY_BRACKET);
        }
    };

    @Override
    public List<Pair<String, String>> read(StringCharReader reader) {
        LinkedList<Pair<String, String>> data = new LinkedList<Pair<String, String>>();
        while (reader.hasMore()) {
            String word = new ExpectWord().read(reader);
            if (word.isEmpty()) continue;
            MutablePair currentParam = new MutablePair((Object)word, (Object)this.readParamValue(reader).trim());
            data.add((Pair<String, String>)currentParam);
        }
        return data;
    }

    private String readParamValue(StringCharReader reader) {
        Stack<Integer> bracketStack = new Stack<Integer>();
        StringBuilder text = new StringBuilder();
        while (reader.hasMore()) {
            char symbol = reader.next();
            if (bracketStack.isEmpty() && symbol == ',') {
                return text.toString();
            }
            if (symbol == '\"') {
                reader.back();
                text.append(Expectations.doubleQuotedText().read(reader));
                continue;
            }
            if (this.isOpeningBracket(symbol)) {
                bracketStack.push(this.bracketType(symbol));
                text.append(symbol);
                continue;
            }
            if (this.isClosingBracket(symbol)) {
                if (Objects.equals(bracketStack.peek(), this.bracketType(symbol))) {
                    text.append(symbol);
                    bracketStack.pop();
                    continue;
                }
                throw new SyntaxException("Unexpected closing bracket: " + symbol);
            }
            text.append(symbol);
        }
        return text.toString();
    }

    private Integer bracketType(char symbol) {
        if (this.bracketsToType.containsKey(Character.valueOf(symbol))) {
            return this.bracketsToType.get(Character.valueOf(symbol));
        }
        throw new SyntaxException("Not a bracket: " + symbol);
    }

    private boolean isClosingBracket(char symbol) {
        return symbol == ']' || symbol == ')' || symbol == '}';
    }

    private boolean isOpeningBracket(char symbol) {
        return symbol == '[' || symbol == '(' || symbol == '{';
    }
}

