/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.config.GalenConfig;
import com.galenframework.parser.ExpectRangeValue;
import com.galenframework.parser.Expectation;
import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.specs.Range;
import com.galenframework.specs.RangeValue;

public class ExpectRange
implements Expectation<Range> {
    private String endingWord = "px";
    private boolean shouldUseEndingWord = true;

    public void setNoEndingWord() {
        this.shouldUseEndingWord = false;
    }

    @Override
    public Range read(StringCharReader reader) {
        Range range;
        RangeType rangeType = this.identifyRangeType(reader);
        RangeValue firstValue = new ExpectRangeValue().read(reader);
        String text = this.expectNonNumeric(reader);
        if (this.shouldUseEndingWord && text.equals(this.endingWord)) {
            return this.createRange(firstValue, rangeType);
        }
        if (text.equals("%")) {
            return this.createRange(firstValue, rangeType).withPercentOf(this.readPercentageOf(reader));
        }
        if (rangeType != RangeType.NOTHING) {
            return this.createRange(firstValue, rangeType);
        }
        if (text.equals("to")) {
            RangeValue secondValue = new ExpectRangeValue().read(reader);
            range = Range.between(firstValue, secondValue);
        } else {
            if (this.shouldUseEndingWord) {
                throw new SyntaxException("Expecting \"px\", \"to\" or \"%\", got \"" + text + "\"");
            }
            range = Range.exact(firstValue);
        }
        String end = this.expectNonNumeric(reader);
        if (this.shouldUseEndingWord && end.equals(this.endingWord)) {
            return range;
        }
        if (end.equals("%")) {
            return range.withPercentOf(this.readPercentageOf(reader));
        }
        if (this.shouldUseEndingWord) {
            throw new SyntaxException("Expecting \"" + this.endingWord + "\", got \"" + end + "\"");
        }
        return range;
    }

    private RangeType identifyRangeType(StringCharReader reader) {
        RangeType rangeType = RangeType.NOTHING;
        char firstNonWhiteSpaceSymbol = reader.firstNonWhiteSpaceSymbol();
        if (firstNonWhiteSpaceSymbol == '~') {
            rangeType = RangeType.APPROXIMATE;
        } else if (firstNonWhiteSpaceSymbol == '>') {
            rangeType = RangeType.GREATER_THAN;
            reader.readSafeUntilSymbol('>');
            if (reader.firstNonWhiteSpaceSymbol() == '=') {
                reader.readSafeUntilSymbol('=');
                rangeType = RangeType.GREATER_THAN_OR_EQUALS;
            }
        } else if (firstNonWhiteSpaceSymbol == '<') {
            rangeType = RangeType.LESS_THAN;
            reader.readSafeUntilSymbol('<');
            if (reader.firstNonWhiteSpaceSymbol() == '=') {
                reader.readSafeUntilSymbol('=');
                rangeType = RangeType.LESS_THAN_OR_EQUALS;
            }
        }
        return rangeType;
    }

    private Range createRange(RangeValue firstValue, RangeType rangeType) {
        if (rangeType == RangeType.APPROXIMATE) {
            Double delta = GalenConfig.getConfig().getRangeApproximation();
            Double firstValueAsDouble = firstValue.asDouble();
            int precision = firstValue.getPrecision();
            return Range.between(new RangeValue(firstValueAsDouble - delta, precision), new RangeValue(firstValueAsDouble + delta, precision));
        }
        if (rangeType == RangeType.GREATER_THAN) {
            return Range.greaterThan(firstValue);
        }
        if (rangeType == RangeType.LESS_THAN) {
            return Range.lessThan(firstValue);
        }
        if (rangeType == RangeType.LESS_THAN_OR_EQUALS) {
            return Range.lessThanOrEquals(firstValue);
        }
        if (rangeType == RangeType.GREATER_THAN_OR_EQUALS) {
            return Range.greaterThanOrEquals(firstValue);
        }
        return Range.exact(firstValue);
    }

    private String readPercentageOf(StringCharReader reader) {
        String firstWord = this.expectNonNumeric(reader);
        if (firstWord.equals("of")) {
            String valuePath = this.expectAnyWord(reader).trim();
            if (valuePath.isEmpty()) {
                throw new SyntaxException("Missing value path for relative range");
            }
            return valuePath;
        }
        throw new SyntaxException("Missing value path for relative range");
    }

    private String expectNonNumeric(StringCharReader reader) {
        boolean started = false;
        StringBuffer buffer = new StringBuffer();
        while (reader.hasMore()) {
            char symbol = reader.next();
            if (started && Expectations.isDelimeter(symbol)) break;
            if (Expectations.isNumeric(symbol)) {
                reader.back();
                break;
            }
            if (Expectations.isDelimeter(symbol)) continue;
            buffer.append(symbol);
            started = true;
        }
        return buffer.toString();
    }

    private String expectAnyWord(StringCharReader reader) {
        boolean started = false;
        StringBuffer buffer = new StringBuffer();
        while (reader.hasMore()) {
            char symbol = reader.next();
            if (started && Expectations.isDelimeter(symbol)) break;
            if (Expectations.isDelimeter(symbol)) continue;
            buffer.append(symbol);
            started = true;
        }
        return buffer.toString();
    }

    private String msgFor(String text) {
        return String.format("Cannot parse range: \"%s\"", text);
    }

    public String getEndingWord() {
        return this.endingWord;
    }

    public void setEndingWord(String endingWord) {
        this.endingWord = endingWord;
    }

    private static enum RangeType {
        NOTHING,
        APPROXIMATE,
        LESS_THAN,
        GREATER_THAN,
        LESS_THAN_OR_EQUALS,
        GREATER_THAN_OR_EQUALS;

    }
}

