/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.CommandLineParser;
import com.galenframework.parser.CommandLineReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.specs.Place;
import com.galenframework.specs.page.Locator;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.suite.actions.GalenPageActionCheck;
import com.galenframework.suite.actions.GalenPageActionCookie;
import com.galenframework.suite.actions.GalenPageActionDumpPage;
import com.galenframework.suite.actions.GalenPageActionInjectJavascript;
import com.galenframework.suite.actions.GalenPageActionMutate;
import com.galenframework.suite.actions.GalenPageActionOpen;
import com.galenframework.suite.actions.GalenPageActionProperties;
import com.galenframework.suite.actions.GalenPageActionResize;
import com.galenframework.suite.actions.GalenPageActionRunJavascript;
import com.galenframework.suite.actions.GalenPageActionWait;
import com.galenframework.suite.actions.mutation.MutationOptions;
import com.galenframework.utils.GalenUtils;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.tuple.Pair;

public class GalenPageActionReader {
    public static GalenPageAction readFrom(String actionText, Place place) {
        String[] args = CommandLineParser.parseCommandLine(actionText);
        if (args.length < 2) {
            throw new SyntaxException(place, "Cannot parse: " + actionText);
        }
        if (args[0].equals("inject")) {
            return GalenPageActionReader.injectActionFrom(args);
        }
        if (args[0].equals("run")) {
            return GalenPageActionReader.runActionFrom(args);
        }
        if (args[0].equals("check")) {
            return GalenPageActionReader.checkActionFrom(args, actionText);
        }
        if (args[0].equals("cookie")) {
            return GalenPageActionReader.cookieActionFrom(args);
        }
        if (args[0].equals("open")) {
            return GalenPageActionReader.openActionFrom(args);
        }
        if (args[0].equals("resize")) {
            return GalenPageActionReader.resizeActionFrom(args);
        }
        if (args[0].equals("wait")) {
            return GalenPageActionReader.waitActionFrom(args);
        }
        if (args[0].equals("properties")) {
            return GalenPageActionReader.propertiesActionFrom(args);
        }
        if (args[0].equals("dump")) {
            return GalenPageActionReader.dumpPageActionFrom(args, actionText);
        }
        if (args[0].equals("mutate")) {
            return GalenPageActionReader.mutatePageActionFrom(args, actionText);
        }
        throw new SyntaxException(place, "Unknown action: " + args[0]);
    }

    private static GalenPageAction resizeActionFrom(String[] args) {
        Dimension size = GalenUtils.readSize(args[1]);
        return new GalenPageActionResize(size.width, size.height);
    }

    private static GalenPageAction propertiesActionFrom(String[] args) {
        LinkedList<String> files = new LinkedList<String>();
        for (int i = 1; i < args.length; ++i) {
            files.add(args[i]);
        }
        return new GalenPageActionProperties().withFiles(files);
    }

    private static GalenPageAction openActionFrom(String[] args) {
        return new GalenPageActionOpen(args[1]);
    }

    private static GalenPageAction cookieActionFrom(String[] args) {
        GalenPageActionCookie action = new GalenPageActionCookie();
        LinkedList<String> cookies = new LinkedList<String>();
        for (int i = 1; i < args.length; ++i) {
            cookies.add(args[i]);
        }
        action.setCookies(cookies);
        return action;
    }

    private static GalenPageAction checkActionFrom(String[] args, String originalText) {
        CommandLineReader reader = new CommandLineReader(args);
        String specPath = null;
        LinkedList<String> includedTags = new LinkedList<String>();
        LinkedList<String> excludedTags = new LinkedList<String>();
        String sectionNameFilter = null;
        HashMap<String, Object> jsVariables = new HashMap<String, Object>();
        reader.skipArgument();
        while (reader.hasNext()) {
            if (!reader.isNextArgument()) {
                specPath = reader.readNext();
                continue;
            }
            Pair<String, String> argument = reader.readArgument();
            if (((String)argument.getKey()).equals("include")) {
                includedTags.addAll(GalenPageActionReader.readTags((String)argument.getValue()));
                continue;
            }
            if (((String)argument.getKey()).equals("exclude")) {
                excludedTags.addAll(GalenPageActionReader.readTags((String)argument.getValue()));
                continue;
            }
            if (((String)argument.getKey()).startsWith("V")) {
                String varName = ((String)argument.getKey()).substring(1);
                String varValue = (String)argument.getValue();
                jsVariables.put(varName, varValue);
                continue;
            }
            if (((String)argument.getKey()).equals("section")) {
                sectionNameFilter = (String)argument.getValue();
                continue;
            }
            throw new SyntaxException("Unknown argument: " + (String)argument.getKey());
        }
        if (specPath == null || specPath.isEmpty()) {
            throw new SyntaxException("Missing spec path");
        }
        return new GalenPageActionCheck().withSpec(specPath).withIncludedTags(includedTags).withExcludedTags(excludedTags).withSectionNameFilter(sectionNameFilter).withJsVariables(jsVariables);
    }

    private static GalenPageAction mutatePageActionFrom(String[] args, String originalText) {
        CommandLineReader reader = new CommandLineReader(args);
        String specPath = null;
        LinkedList<String> includedTags = new LinkedList<String>();
        LinkedList<String> excludedTags = new LinkedList<String>();
        Object sectionNameFilter = null;
        int offset = 5;
        reader.skipArgument();
        while (reader.hasNext()) {
            if (!reader.isNextArgument()) {
                specPath = reader.readNext();
                continue;
            }
            Pair<String, String> argument = reader.readArgument();
            if (((String)argument.getKey()).equals("include")) {
                includedTags.addAll(GalenPageActionReader.readTags((String)argument.getValue()));
                continue;
            }
            if (((String)argument.getKey()).equals("exclude")) {
                excludedTags.addAll(GalenPageActionReader.readTags((String)argument.getValue()));
                continue;
            }
            if (((String)argument.getKey()).equals("offset")) {
                offset = Integer.parseInt((String)argument.getValue());
                continue;
            }
            throw new SyntaxException("Unknown argument: " + (String)argument.getKey());
        }
        if (specPath == null || specPath.isEmpty()) {
            throw new SyntaxException("Missing spec path");
        }
        return new GalenPageActionMutate().withSpec(specPath).withIncludedTags(includedTags).withExcludedTags(excludedTags).withMutationOptions(new MutationOptions().setPositionOffset(offset)).withOriginalCommand(originalText);
    }

    private static GalenPageAction dumpPageActionFrom(String[] args, String originalText) {
        Options options = new Options();
        options.addOption("n", "name", true, "Page name");
        options.addOption("e", "export", true, "Export dir");
        options.addOption("w", "max-width", true, "Maximal width of elements in croppped screenshots");
        options.addOption("h", "max-height", true, "Maximal height of elements in cropped screenshots");
        options.addOption("i", "only-images", false, "Flag for exporting only images without html and json files");
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            String[] leftoverArgs = cmd.getArgs();
            if (leftoverArgs == null || leftoverArgs.length < 2) {
                throw new SyntaxException("There are no page specs: " + originalText);
            }
            Integer maxWidth = null;
            Integer maxHeight = null;
            String maxWidthText = cmd.getOptionValue("w");
            String maxHeightText = cmd.getOptionValue("h");
            if (maxWidthText != null && !maxWidthText.isEmpty()) {
                maxWidth = Integer.parseInt(maxWidthText);
            }
            if (maxHeightText != null && !maxHeightText.isEmpty()) {
                maxHeight = Integer.parseInt(maxHeightText);
            }
            boolean onlyImages = cmd.hasOption("i");
            return new GalenPageActionDumpPage().withSpecPath(leftoverArgs[1]).withPageName(cmd.getOptionValue("n")).withPageDumpPath(cmd.getOptionValue("e")).withMaxWidth(maxWidth).withMaxHeight(maxHeight).withOnlyImages(onlyImages);
        }
        catch (Exception e) {
            throw new SyntaxException("Couldn't parse: " + originalText, (Throwable)e);
        }
    }

    private static List<String> readTags(String tagsCommaSeparated) {
        if (tagsCommaSeparated != null) {
            String[] tagsArray = tagsCommaSeparated.split(",");
            LinkedList<String> tags = new LinkedList<String>();
            for (String tag : tagsArray) {
                if ((tag = tag.trim()).isEmpty()) continue;
                tags.add(tag);
            }
            return tags;
        }
        return null;
    }

    private static GalenPageAction runActionFrom(String[] args) {
        String jsonArguments = null;
        if (args.length > 2) {
            jsonArguments = args[2];
        }
        return new GalenPageActionRunJavascript(args[1]).withJsonArguments(jsonArguments);
    }

    private static GalenPageAction waitActionFrom(String[] args) {
        if (args.length < 2) {
            throw new SyntaxException("the timeout is not specified");
        }
        GalenPageActionWait wait = new GalenPageActionWait();
        wait.setTimeout(GalenPageActionReader.parseTimeout(args[1]));
        if (args.length > 2) {
            GalenPageActionReader.parseUntilConditions(wait, args);
        }
        return wait;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseUntilConditions(GalenPageActionWait wait, String[] args) {
        if (!args[2].equals("until")) throw new SyntaxException(String.format("Expected \"until\" but got \"%s\"", args[2]));
        if (args.length <= 3) throw new SyntaxException("You have to provide locators");
        LinkedList<GalenPageActionWait.Until> untilElements = new LinkedList<GalenPageActionWait.Until>();
        GalenPageActionWait.UntilType currentType = null;
        for (int i = 3; i < args.length; ++i) {
            GalenPageActionWait.UntilType type = GalenPageActionWait.UntilType.parseNonStrict(args[i]);
            if (type != null) {
                currentType = type;
                continue;
            }
            if (currentType == null) {
                throw new SyntaxException("You have to specify one of the following checks: visible, hidden, exist, gone");
            }
            untilElements.add(new GalenPageActionWait.Until(currentType, Locator.parse(args[i])));
        }
        wait.setUntilElements(untilElements);
    }

    private static int parseTimeout(String timeoutText) {
        for (int i = 0; i < timeoutText.length(); ++i) {
            if (GalenPageActionReader.isNumber(timeoutText.charAt(i))) continue;
            int number = Integer.parseInt(timeoutText.substring(0, i));
            String unitPart = timeoutText.substring(i);
            if (unitPart.equals("s")) {
                return 1000 * number;
            }
            if (unitPart.equals("ms")) {
                return number;
            }
            if (unitPart.equals("m")) {
                return 60000 * number;
            }
            throw new SyntaxException("Unkown time unit: " + unitPart);
        }
        return Integer.parseInt(timeoutText);
    }

    private static boolean isNumber(char symbol) {
        char code = symbol;
        return code > '/' && code < ':';
    }

    private static GalenPageActionInjectJavascript injectActionFrom(String[] args) {
        return new GalenPageActionInjectJavascript(args[1]);
    }
}

