/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.specs.Place;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class StructNode {
    public static final StructNode UNKNOWN_SOURCE = new StructNode();
    private String name;
    private List<StructNode> childNodes;
    private Place place;

    public StructNode(String name) {
        this.name = name;
    }

    public StructNode() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setChildNodes(List<StructNode> childNodes) {
        this.childNodes = childNodes;
    }

    public List<StructNode> getChildNodes() {
        return this.childNodes;
    }

    public void addChildNode(StructNode childNode) {
        if (this.childNodes == null) {
            this.childNodes = new LinkedList<StructNode>();
        }
        this.childNodes.add(childNode);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StructNode)) {
            return false;
        }
        StructNode rhs = (StructNode)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).append(this.childNodes, rhs.childNodes).append((Object)this.place, (Object)rhs.place).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append(this.childNodes).append((Object)this.place).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("childNodes", this.childNodes).append("place", (Object)this.place).toString();
    }

    public boolean hasChildNodes() {
        return this.childNodes != null && !this.childNodes.isEmpty();
    }

    public String assembleAllNodes() {
        return this.assembleAllNodes("");
    }

    private String assembleAllNodes(String indentation) {
        StringBuilder builder = new StringBuilder();
        builder.append(indentation);
        builder.append(this.name);
        builder.append('\n');
        if (this.childNodes != null) {
            for (StructNode childNode : this.childNodes) {
                builder.append(childNode.assembleAllNodes(indentation + "    "));
            }
        }
        return builder.toString();
    }

    public String assembleAllChildNodes() {
        StringBuilder builder = new StringBuilder();
        if (this.childNodes != null) {
            for (StructNode childNode : this.childNodes) {
                builder.append(childNode.assembleAllNodes());
            }
        }
        return builder.toString();
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public Place getPlace() {
        return this.place;
    }
}

