/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports;

import com.galenframework.config.GalenConfig;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.TestStatistic;
import com.galenframework.runner.CompleteListener;
import com.galenframework.specs.Spec;
import com.galenframework.specs.page.PageSection;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.tests.GalenTest;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationResult;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public class ConsoleReportingListener
implements CompleteListener {
    private static final String SPEC_ERROR_MESSAGE_INDENTATION_SUFFIX = ":   ";
    private static final String SPEC_ERROR_INDENTATION_HEADER = "->  ";
    private static final String NORMAL_INDETATION = "    ";
    private static final int TEST_LEVEL = 1;
    private static final int PAGE_LEVEL = 2;
    private static final int SECTION_LEVEL = 3;
    private static final int OBJECT_LEVEL = 4;
    private static final int OBJECT_SPEC_LEVEL = 5;
    private PrintStream out;
    private PrintStream err;
    private ThreadLocal<Integer> currentObjectLevel = new ThreadLocal();
    private int logLevel = this.getLogLevel();

    public ConsoleReportingListener(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    private int getLogLevel() {
        return GalenConfig.getConfig().getLogLevel();
    }

    @Override
    public void onObject(PageValidation pageValidation, String objectName) {
        if (this.logLevel >= 4) {
            this.increaseCurrentObjectLevel();
            this.out.print(this.getObjectIndentation());
            this.out.print(objectName);
            this.out.println(":");
        }
    }

    private String getObjectIndentation() {
        Integer level = this.currentObjectLevel.get();
        if (level != null && level > 0) {
            StringBuffer buffer = new StringBuffer(NORMAL_INDETATION);
            for (int i = 0; i <= level; ++i) {
                buffer.append(NORMAL_INDETATION);
            }
            return buffer.toString();
        }
        return NORMAL_INDETATION;
    }

    @Override
    public void onAfterObject(PageValidation pageValidation, String objectName) {
        this.decreaseCurrentObjectLevel();
        if (this.logLevel >= 4) {
            this.out.println();
        }
    }

    @Override
    public void onBeforeSpec(PageValidation pageValidation, String objectName, Spec spec) {
    }

    private void decreaseCurrentObjectLevel() {
        Integer value = this.currentObjectLevel.get();
        if (value != null) {
            if (value > 0) {
                value = value - 1;
                this.currentObjectLevel.set(value);
            } else {
                this.currentObjectLevel.remove();
            }
        }
    }

    private void increaseCurrentObjectLevel() {
        Integer value = this.currentObjectLevel.get();
        if (value == null) {
            this.currentObjectLevel.set(0);
        } else {
            value = value + 1;
            this.currentObjectLevel.set(value);
        }
    }

    @Override
    public void onSpecError(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        if (this.logLevel >= 5) {
            this.err.print(this.getSpecErrorIndentation());
            this.err.println(spec.toText());
            if (result.getError().getMessages() != null) {
                for (String message : result.getError().getMessages()) {
                    this.err.print(this.getSpecErrorIndentation());
                    this.err.print(SPEC_ERROR_MESSAGE_INDENTATION_SUFFIX);
                    this.err.println(message);
                }
            }
        }
    }

    private String getSpecErrorIndentation() {
        Integer level = this.currentObjectLevel.get();
        if (level != null && level > 0) {
            StringBuffer buffer = new StringBuffer(SPEC_ERROR_INDENTATION_HEADER);
            for (int i = 0; i <= level + 1; ++i) {
                buffer.append(NORMAL_INDETATION);
            }
            return buffer.toString();
        }
        return "->      ";
    }

    @Override
    public void onSpecSuccess(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        if (this.logLevel >= 5) {
            this.out.print(this.getObjectIndentation());
            this.out.print(NORMAL_INDETATION);
            this.out.println(spec.toText());
        }
    }

    @Override
    public void onTestFinished(GalenTest test) {
    }

    @Override
    public void onTestStarted(GalenTest test) {
        if (this.logLevel >= 1) {
            this.out.println("========================================");
            this.out.print("Test: ");
            this.out.println(test.getName());
            this.out.println("========================================");
        }
    }

    @Override
    public void done() {
    }

    @Override
    public void onGlobalError(Exception e) {
        e.printStackTrace(this.err);
    }

    @Override
    public void onBeforePageAction(GalenPageAction action) {
        if (this.logLevel > 2) {
            this.out.println(action.getOriginalCommand());
        }
    }

    @Override
    public void onAfterPageAction(GalenPageAction action) {
    }

    @Override
    public void onBeforeSection(PageValidation pageValidation, PageSection pageSection) {
        if (this.logLevel >= 3) {
            this.out.print("= ");
            String name = pageSection.getName();
            if (name != null && !name.trim().isEmpty()) {
                this.out.print(pageSection.getName());
            } else {
                this.out.print("Unnamed");
            }
            this.out.println(" =");
        }
    }

    @Override
    public void onAfterSection(PageValidation pageValidation, PageSection pageSection) {
    }

    @Override
    public void onSubLayout(PageValidation pageValidation, String objectName) {
    }

    @Override
    public void onAfterSubLayout(PageValidation pageValidation, String objectName) {
    }

    @Override
    public void onSpecGroup(PageValidation pageValidation, String specGroupName) {
    }

    @Override
    public void onAfterSpecGroup(PageValidation pageValidation, String specGroupName) {
    }

    @Override
    public void beforeTestSuite(List<GalenTest> tests) {
    }

    @Override
    public void afterTestSuite(List<GalenTestInfo> tests) {
        this.out.println();
        this.out.println("========================================");
        this.out.println("----------------------------------------");
        this.out.println("========================================");
        LinkedList<String> failedTests = new LinkedList<String>();
        TestStatistic allStatistic = new TestStatistic();
        for (GalenTestInfo test : tests) {
            TestStatistic statistic = test.getReport().fetchStatistic();
            allStatistic.add(statistic);
            if (test.getException() == null && statistic.getErrors() <= 0) continue;
            failedTests.add(test.getName());
        }
        if (failedTests.size() > 0) {
            this.out.println("Failed tests:");
            for (String name : failedTests) {
                this.out.println(NORMAL_INDETATION + name);
            }
            this.out.println();
        }
        this.out.print("Suite status: ");
        if (failedTests.size() > 0) {
            this.out.println("FAIL");
        } else {
            this.out.println("PASS");
        }
        this.out.println("Total tests: " + tests.size());
        this.out.println("Total failed tests: " + failedTests.size());
        this.out.println("Total failures: " + allStatistic.getErrors());
    }
}

