/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.LoopVisitor;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.specs.Place;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ForLoop {
    public static final String DEFAULT_VARIABLE_NAME = "index";
    private String indexMapping;
    private String previousMapping;
    private String nextMapping;
    private Object[] sequence;
    private String variableName;

    public ForLoop(Object[] sequence, String variableName, String previousMapping, String nextMapping, String indexMapping) {
        this.sequence = sequence;
        this.variableName = variableName;
        this.previousMapping = previousMapping;
        this.nextMapping = nextMapping;
        this.indexMapping = indexMapping;
    }

    public static ForLoop read(boolean isSimpleLoop, PageSpecHandler pageSpecHandler, StringCharReader reader, StructNode originNode) {
        try {
            String emptyness = reader.readUntilSymbol('[').trim();
            if (!emptyness.isEmpty()) {
                throw new SyntaxException(originNode, "Unexpected token: " + emptyness);
            }
            String sequenceStatement = reader.readUntilSymbol(']');
            Object[] sequence = isSimpleLoop ? ForLoop.readSequenceForSimpleLoop(sequenceStatement, originNode.getPlace()) : ForLoop.readSequenceFromPageObjects(sequenceStatement, pageSpecHandler);
            String variableName = DEFAULT_VARIABLE_NAME;
            String previousMapping = null;
            String nextMapping = null;
            String indexMapping = null;
            if (reader.hasMoreNormalSymbols()) {
                String nextWord = reader.readWord();
                if (!nextWord.equals("as")) {
                    throw new SyntaxException("Invalid token: " + nextWord);
                }
                variableName = reader.readWord();
                if (variableName.isEmpty()) {
                    throw new SyntaxException("Missing index");
                }
                if (reader.hasMoreNormalSymbols()) {
                    reader.readUntilSymbol(',');
                    Pair<String, String> extraMappings = ForLoop.parseExtraMapping(reader);
                    if ("prev".equals(extraMappings.getKey())) {
                        previousMapping = (String)extraMappings.getValue();
                    } else if ("next".equals(extraMappings.getKey())) {
                        nextMapping = (String)extraMappings.getValue();
                    } else if (DEFAULT_VARIABLE_NAME.equals(extraMappings.getKey())) {
                        indexMapping = (String)extraMappings.getValue();
                    } else {
                        throw new SyntaxException("Unknown loop mapping: " + (String)extraMappings.getKey());
                    }
                }
            }
            return new ForLoop(sequence, variableName, previousMapping, nextMapping, indexMapping);
        }
        catch (SyntaxException ex) {
            ex.setPlace(originNode.getPlace());
            throw ex;
        }
    }

    private static Pair<String, String> parseExtraMapping(StringCharReader reader) {
        String type = reader.readWord();
        String as = reader.readWord();
        String varName = reader.readWord();
        if (type.isEmpty()) {
            throw new SyntaxException("Missing type. Expected 'prev' or 'next'");
        }
        if (!"as".equals(as)) {
            throw new SyntaxException("Incorrect statement. Use 'as'");
        }
        if (varName.isEmpty()) {
            throw new SyntaxException("Missing mapping name for '" + type + "'");
        }
        String theRest = reader.getTheRest().trim();
        if (!theRest.isEmpty()) {
            throw new SyntaxException("Cannot process: " + theRest);
        }
        return new ImmutablePair((Object)type, (Object)varName);
    }

    private static String[] readSequenceFromPageObjects(String sequenceStatement, PageSpecHandler pageSpecHandler) {
        List<String> matchingObjects = pageSpecHandler.findAllObjectsMatchingStrictStatements(sequenceStatement);
        return matchingObjects.toArray(new String[matchingObjects.size()]);
    }

    private static Object[] readSequenceForSimpleLoop(String sequenceStatement, Place place) {
        sequenceStatement = sequenceStatement.replace(" ", "");
        sequenceStatement = sequenceStatement.replace("\t", "");
        Pattern sequencePattern = Pattern.compile(".*\\-.*");
        try {
            String[] values = sequenceStatement.split(",");
            ArrayList<Object> sequence = new ArrayList<Object>();
            for (String stringValue : values) {
                if (sequencePattern.matcher(stringValue).matches()) {
                    sequence.addAll(ForLoop.createSequence(stringValue));
                    continue;
                }
                sequence.add(ForLoop.convertValueToIndex(stringValue));
            }
            return sequence.toArray(new Object[sequence.size()]);
        }
        catch (Exception ex) {
            throw new SyntaxException(place, "Incorrect sequence syntax: " + sequenceStatement, (Throwable)ex);
        }
    }

    private static Object convertValueToIndex(String stringValue) {
        if (NumberUtils.isNumber((String)stringValue)) {
            return NumberUtils.toLong((String)stringValue);
        }
        return stringValue;
    }

    private static List<Object> createSequence(String value) {
        int dashIndex = value.indexOf(45);
        int rangeA = Integer.parseInt(value.substring(0, dashIndex));
        int rangeB = Integer.parseInt(value.substring(dashIndex + 1));
        return ForLoop.createSequence(rangeA, rangeB);
    }

    private static List<Object> createSequence(int min, int max) {
        if (max >= min) {
            LinkedList<Object> parameters = new LinkedList<Object>();
            for (int i = min; i <= max; ++i) {
                parameters.add(i);
            }
            return parameters;
        }
        return Collections.emptyList();
    }

    public List<StructNode> apply(LoopVisitor loopVisitor) throws IOException {
        LinkedList<StructNode> resultingNodes = new LinkedList<StructNode>();
        int begin = 0;
        int end = this.sequence.length;
        if (this.previousMapping != null) {
            begin = 1;
        }
        if (this.nextMapping != null) {
            --end;
        }
        int index = 0;
        for (int i = begin; i < end; ++i) {
            ++index;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put(this.variableName, this.sequence[i]);
            if (this.previousMapping != null) {
                vars.put(this.previousMapping, this.sequence[i - 1]);
            }
            if (this.nextMapping != null) {
                vars.put(this.nextMapping, this.sequence[i + 1]);
            }
            if (this.indexMapping != null) {
                vars.put(this.indexMapping, index);
            }
            resultingNodes.addAll(loopVisitor.visitLoop(vars));
        }
        return resultingNodes;
    }
}

