/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.IndentationStructureParser;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.MacroProcessor;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.speclang2.pagespec.PostProcessor;
import com.galenframework.speclang2.pagespec.StructNodeProcessor;
import com.galenframework.utils.GalenUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ImportProcessor
implements StructNodeProcessor {
    protected final PageSpecHandler pageSpecHandler;

    public ImportProcessor(PageSpecHandler pageSpecHandler) {
        this.pageSpecHandler = pageSpecHandler;
    }

    @Override
    public List<StructNode> process(StringCharReader reader, StructNode statementNode) throws IOException {
        LinkedList<StructNode> importedNodes = new LinkedList<StructNode>();
        if (reader.hasMoreNormalSymbols()) {
            importedNodes.addAll(this.importPageSpec(reader.getTheRest().trim(), statementNode));
        }
        if (statementNode.getChildNodes() != null) {
            for (StructNode childNode : statementNode.getChildNodes()) {
                importedNodes.addAll(this.importPageSpec(childNode.getName(), childNode));
            }
        }
        return importedNodes;
    }

    protected List<StructNode> importPageSpec(String filePath, StructNode origin) throws IOException {
        String fullPath = filePath;
        if (this.pageSpecHandler.getContextPath() != null) {
            fullPath = this.pageSpecHandler.getContextPath() + "/" + filePath;
        }
        return this.loadPageSpec(origin, fullPath);
    }

    protected List<StructNode> loadPageSpec(StructNode origin, String fullPath) throws IOException {
        String fileId = GalenUtils.calculateFileId(fullPath);
        if (!this.pageSpecHandler.getProcessedImports().contains(fileId)) {
            this.pageSpecHandler.getProcessedImports().add(fileId);
            InputStream stream = GalenUtils.findFileOrResourceAsStream(fullPath);
            if (stream == null) {
                throw new SyntaxException(origin, "Cannot find file: " + fullPath);
            }
            List<StructNode> structs = new IndentationStructureParser().parse(stream, fullPath);
            PageSpecHandler childPageSpecHandler = new PageSpecHandler(this.pageSpecHandler, GalenUtils.getParentForFile(fullPath));
            List<StructNode> allProcessedChildNodes = new MacroProcessor(childPageSpecHandler).process(structs);
            new PostProcessor(childPageSpecHandler).process(allProcessedChildNodes);
        }
        return Collections.emptyList();
    }
}

