/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.ImportProcessor;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class LibProcessor
extends ImportProcessor {
    private final List<String> embeddedLibraryNames = this.loadLibraryNamesFrom("/spec-libs/libs.list");

    public LibProcessor(PageSpecHandler pageSpecHandler) {
        super(pageSpecHandler);
    }

    private List<String> loadLibraryNamesFrom(String path) {
        try {
            String text = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(path));
            return Arrays.asList(text.split("\r\n")).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't load libraries from " + path, e);
        }
    }

    @Override
    protected List<StructNode> importPageSpec(String filePath, StructNode origin) throws IOException {
        if (!this.embeddedLibraryNames.contains(filePath)) {
            throw new SyntaxException(origin, "Cannot find library: " + filePath);
        }
        return this.loadPageSpec(origin, "/spec-libs/" + filePath + "/" + filePath + ".gspec");
    }
}

