/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.ForLoop;
import com.galenframework.speclang2.pagespec.GroupsDefinitionProcessor;
import com.galenframework.speclang2.pagespec.ImportProcessor;
import com.galenframework.speclang2.pagespec.LibProcessor;
import com.galenframework.speclang2.pagespec.ObjectDefinitionProcessor;
import com.galenframework.speclang2.pagespec.OnFilterProcessor;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.speclang2.pagespec.RuleProcessor;
import com.galenframework.speclang2.pagespec.ScriptProcessor;
import com.galenframework.speclang2.pagespec.SetVariableProcessor;
import com.galenframework.speclang2.pagespec.StructNodeProcessor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MacroProcessor {
    public static final String FOR_LOOP_KEYWORD = "@for";
    public static final String FOR_EACH_LOOP_KEYWORD = "@forEach";
    public static final String SET_KEYWORD = "@set";
    public static final String OBJECTS_KEYWORD = "@objects";
    public static final String GROUPS_KEYWORD = "@groups";
    public static final String ON_KEYWORD = "@on";
    public static final String IMPORT_KEYWORD = "@import";
    public static final String LIB_KEYWORD = "@lib";
    public static final String SCRIPT_KEYWORD = "@script";
    public static final String RULE_KEYWORD = "@rule";
    public static final String RULE_BODY = "@ruleBody";
    public static final String IF_KEYWORD = "@if";
    public static final String ELSEIF_KEYWORD = "@elseif";
    public static final String ELSE_KEYWORD = "@else";
    public static final String DIE_KEYWORD = "@die";
    private final PageSpecHandler pageSpecHandler;
    private List<String> macroOperators = Arrays.asList("@for", "@forEach", "@set", "@objects", "@groups", "@on", "@import", "@lib", "@script", "@rule", "@ruleBody", "@die");
    private List<StructNode> currentRuleBody;
    private final Map<String, StructNodeProcessor> structNodeProcessorMap;

    public MacroProcessor(PageSpecHandler pageSpecHandler) {
        this.pageSpecHandler = pageSpecHandler;
        this.structNodeProcessorMap = this.createStructNodeProcessMap(pageSpecHandler);
    }

    public List<StructNode> process(List<StructNode> nodes) throws IOException {
        if (nodes != null) {
            LinkedList<StructNode> resultingNodes = new LinkedList<StructNode>();
            ListIterator<StructNode> it = nodes.listIterator();
            while (it.hasNext()) {
                StructNode node = it.next();
                if (this.isConditionStatement(node.getName())) {
                    resultingNodes.addAll(this.processConditionStatements(node, it));
                    continue;
                }
                StructNode processedNode = this.pageSpecHandler.processExpressionsIn(node);
                if (this.isMacroStatement(processedNode.getName())) {
                    resultingNodes.addAll(this.processMacroStatement(processedNode));
                    continue;
                }
                resultingNodes.add(this.processNonMacroStatement(processedNode));
            }
            return resultingNodes;
        }
        return Collections.emptyList();
    }

    private List<StructNode> processConditionStatements(StructNode ifNode, ListIterator<StructNode> it) throws IOException {
        LinkedList<StructNode> elseIfNodes = new LinkedList<StructNode>();
        StructNode elseNode = null;
        boolean finishedConditions = false;
        while (it.hasNext() && !finishedConditions) {
            StructNode nextNode = it.next();
            String firstWord = new StringCharReader(nextNode.getName()).readWord();
            if (firstWord.equals(ELSEIF_KEYWORD)) {
                if (elseNode != null) {
                    throw new SyntaxException(nextNode, "Cannot use elseif statement after else block");
                }
                elseIfNodes.add(this.processExpressionsIn(nextNode));
                continue;
            }
            if (firstWord.equals(ELSE_KEYWORD)) {
                if (elseNode != null) {
                    throw new SyntaxException(nextNode, "Cannot use else statement after else block");
                }
                elseNode = this.processExpressionsIn(nextNode);
                continue;
            }
            finishedConditions = true;
            it.previous();
        }
        List<StructNode> nodesFromConditions = this.applyConditions(this.processExpressionsIn(ifNode), elseIfNodes, elseNode);
        return this.process(nodesFromConditions);
    }

    private StructNode processExpressionsIn(StructNode ifNode) {
        try {
            return this.pageSpecHandler.processExpressionsIn(ifNode);
        }
        catch (Exception ex) {
            throw new SyntaxException(ifNode, "JavaScript error inside statement");
        }
    }

    private List<StructNode> applyConditions(StructNode ifNode, List<StructNode> elseIfNodes, StructNode elseNode) {
        if (this.isSuccessfullCondition(ifNode)) {
            return ifNode.getChildNodes();
        }
        if (elseIfNodes != null) {
            for (StructNode node : elseIfNodes) {
                if (!this.isSuccessfullCondition(node)) continue;
                return node.getChildNodes();
            }
        }
        if (elseNode != null) {
            return elseNode.getChildNodes();
        }
        return Collections.emptyList();
    }

    private boolean isSuccessfullCondition(StructNode node) {
        StringCharReader reader = new StringCharReader(node.getName());
        reader.readWord();
        String booleanText = reader.readWord();
        if (booleanText.isEmpty()) {
            throw new SyntaxException(node, "Missing boolean statement in condition");
        }
        try {
            return Boolean.parseBoolean(booleanText);
        }
        catch (Exception ex) {
            throw new SyntaxException(node, "Couldn't parse boolean", (Throwable)ex);
        }
    }

    private boolean isConditionStatement(String name) {
        return IF_KEYWORD.equals(new StringCharReader(name).readWord());
    }

    private StructNode processNonMacroStatement(StructNode processedNode) throws IOException {
        if (processedNode.getChildNodes() != null) {
            StructNode fullyProcessed = new StructNode(processedNode.getName());
            fullyProcessed.setPlace(processedNode.getPlace());
            fullyProcessed.setChildNodes(this.process(processedNode.getChildNodes()));
            return fullyProcessed;
        }
        return processedNode;
    }

    private Map<String, StructNodeProcessor> createStructNodeProcessMap(final PageSpecHandler pageSpecHandler) {
        return new HashMap<String, StructNodeProcessor>(){
            {
                this.put(MacroProcessor.SET_KEYWORD, new SetVariableProcessor(pageSpecHandler));
                this.put(MacroProcessor.OBJECTS_KEYWORD, new ObjectDefinitionProcessor(pageSpecHandler));
                this.put(MacroProcessor.GROUPS_KEYWORD, new GroupsDefinitionProcessor(pageSpecHandler));
                this.put(MacroProcessor.ON_KEYWORD, new OnFilterProcessor(pageSpecHandler));
                this.put(MacroProcessor.IMPORT_KEYWORD, new ImportProcessor(pageSpecHandler));
                this.put(MacroProcessor.LIB_KEYWORD, new LibProcessor(pageSpecHandler));
                this.put(MacroProcessor.SCRIPT_KEYWORD, new ScriptProcessor(pageSpecHandler));
                this.put(MacroProcessor.RULE_KEYWORD, new RuleProcessor(pageSpecHandler));
            }
        };
    }

    private List<StructNode> processMacroStatement(StructNode statementNode) throws IOException {
        StringCharReader reader = new StringCharReader(statementNode.getName());
        String firstWord = reader.readWord();
        if (this.structNodeProcessorMap.containsKey(firstWord)) {
            return this.process(this.structNodeProcessorMap.get(firstWord).process(reader, statementNode));
        }
        if (FOR_LOOP_KEYWORD.equals(firstWord) || FOR_EACH_LOOP_KEYWORD.equals(firstWord)) {
            ForLoop forLoop = ForLoop.read(FOR_LOOP_KEYWORD.equals(firstWord), this.pageSpecHandler, reader, statementNode);
            return forLoop.apply(variables -> {
                this.pageSpecHandler.setGlobalVariables(variables, statementNode);
                return this.process(statementNode.getChildNodes());
            });
        }
        if (ELSEIF_KEYWORD.equals(firstWord)) {
            throw new SyntaxException(statementNode, "elseif statement without if block");
        }
        if (ELSE_KEYWORD.equals(firstWord)) {
            throw new SyntaxException(statementNode, "else statement without if block");
        }
        if (DIE_KEYWORD.equals(firstWord)) {
            throw new SyntaxException(statementNode, Expectations.doubleQuotedText().read(reader));
        }
        if (RULE_BODY.equals(firstWord)) {
            if (this.currentRuleBody != null) {
                return this.currentRuleBody;
            }
            return Collections.emptyList();
        }
        throw new SyntaxException(statementNode, "Invalid statement: " + firstWord);
    }

    private boolean isMacroStatement(String name) {
        String firstWord = new StringCharReader(name).readWord();
        return this.macroOperators.contains(firstWord);
    }

    public MacroProcessor setCurrentRuleBody(List<StructNode> currentRuleBody) {
        this.currentRuleBody = currentRuleBody;
        return this;
    }

    public List<StructNode> getCurrentRuleBody() {
        return this.currentRuleBody;
    }
}

