/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.page.Page;
import com.galenframework.parser.ExpectWord;
import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.speclang2.pagespec.StructNodeProcessor;
import com.galenframework.specs.page.CorrectionsRect;
import com.galenframework.specs.page.Locator;
import com.galenframework.utils.GalenUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class ObjectDefinitionProcessor
implements StructNodeProcessor {
    public static final String GROUPED = "@grouped";
    private final PageSpecHandler pageSpecHandler;
    private static final String CORRECTIONS_SYMBOL = "@";
    private Stack<List<String>> groupStack = new Stack();

    public ObjectDefinitionProcessor(PageSpecHandler pageSpecHandler) {
        this.pageSpecHandler = pageSpecHandler;
    }

    @Override
    public List<StructNode> process(StringCharReader reader, StructNode structNode) {
        if (!reader.getTheRest().isEmpty()) {
            throw new SyntaxException(structNode.getPlace(), "Objects definition does not take any arguments");
        }
        if (structNode.getChildNodes() != null) {
            this.groupStack = new Stack();
            for (StructNode childNode : structNode.getChildNodes()) {
                this.parseItem(childNode);
            }
        }
        return Collections.emptyList();
    }

    private void parseItem(StructNode objectNode) {
        this.parseItem(objectNode, null, null);
    }

    private void parseItem(StructNode objectNode, String parentName, Locator parentLocator) {
        this.processObject(objectNode, parentName, parentLocator);
    }

    private void processObject(StructNode objectNode, String parentName, Locator parentLocator) {
        StringCharReader reader = new StringCharReader(this.pageSpecHandler.processExpressionsIn(objectNode).getName());
        String objectName = reader.readWord();
        if (parentName != null) {
            objectName = parentName + "." + objectName;
        }
        String locatorText = null;
        List<String> groups = null;
        CorrectionsRect corrections = null;
        while (reader.hasMore()) {
            String word = this.expectCorrectionsOrId(objectNode, reader, objectName);
            if (word.equals(CORRECTIONS_SYMBOL)) {
                corrections = Expectations.corrections().read(reader);
                continue;
            }
            if (word.equals(GROUPED)) {
                groups = this.parseInlineGroupsInBrackets(reader);
                continue;
            }
            locatorText = word + reader.getTheRest();
            reader.moveToTheEnd();
        }
        if (locatorText == null) {
            throw new SyntaxException("Missing locator");
        }
        Locator locator = this.readLocatorFromString(objectNode, objectName, locatorText.trim());
        locator.setCorrections(corrections);
        if (parentLocator != null) {
            locator.setParent(parentLocator);
        }
        if (objectName.contains("*")) {
            this.addMultiObjectsToSpec(objectNode, objectName, locator, groups);
        } else {
            this.addObjectToSpec(objectNode, objectName, locator, groups);
        }
    }

    private List<String> parseInlineGroupsInBrackets(StringCharReader reader) {
        if (reader.firstNonWhiteSpaceSymbol() == '(') {
            reader.readUntilSymbol('(');
            return GalenUtils.fromCommaSeparated(reader.readUntilSymbol(')'));
        }
        throw new SyntaxException("Missing '(' for group definitions");
    }

    private void addObjectToSpec(StructNode objectNode, String objectName, Locator locator, List<String> groupsForThisObject) {
        if (!objectName.matches("[0-9a-zA-Z_\\.\\-]*")) {
            throw new SyntaxException("Invalid object name: " + objectName);
        }
        this.pageSpecHandler.addObjectToSpec(objectName, locator);
        List<String> allCurrentGroups = this.getAllCurrentGroups();
        if (allCurrentGroups != null && !allCurrentGroups.isEmpty()) {
            this.pageSpecHandler.applyGroupsToObject(objectName, allCurrentGroups);
        }
        if (groupsForThisObject != null && !groupsForThisObject.isEmpty()) {
            this.pageSpecHandler.applyGroupsToObject(objectName, groupsForThisObject);
        }
        if (objectNode.getChildNodes() != null && objectNode.getChildNodes().size() > 0) {
            for (StructNode subObjectNode : objectNode.getChildNodes()) {
                this.parseItem(this.pageSpecHandler.processExpressionsIn(subObjectNode), objectName, locator);
            }
        }
    }

    private void addMultiObjectsToSpec(StructNode objectNode, String objectName, Locator locator, List<String> groupsForThisObject) {
        Page page = this.pageSpecHandler.getPage();
        int count = page.getObjectCount(locator);
        for (int index = 1; index <= count; ++index) {
            this.addObjectToSpec(objectNode, objectName.replace("*", Integer.toString(index)), new Locator(locator.getLocatorType(), locator.getLocatorValue(), index).withParent(locator.getParent()).withCorrections(locator.getCorrections()), groupsForThisObject);
        }
    }

    private Locator readLocatorFromString(StructNode structNode, String objectName, String locatorText) {
        if (locatorText.isEmpty()) {
            throw new SyntaxException(structNode.getPlace(), "Missing locator for object \"" + objectName + "\"");
        }
        StringCharReader reader = new StringCharReader(locatorText);
        String firstWord = reader.readWord();
        String locatorValue = reader.getTheRest().trim();
        if ("id".equals(firstWord) || "css".equals(firstWord) || "xpath".equals(firstWord)) {
            return this.createLocator(objectName, firstWord, locatorValue);
        }
        return this.identifyLocator(locatorText);
    }

    private Locator identifyLocator(String locatorText) {
        if (locatorText.startsWith("/")) {
            return new Locator("xpath", locatorText);
        }
        return new Locator("css", locatorText);
    }

    private Locator createLocator(String objectName, String type, String value) {
        if (value == null || value.isEmpty()) {
            throw new SyntaxException("Locator for object \"" + objectName + "\" is not defined correctly");
        }
        return new Locator(type, value);
    }

    private String expectCorrectionsOrId(StructNode structNode, StringCharReader reader, String objectName) {
        String word = new ExpectWord().stopOnTheseSymbols('(').read(reader).trim();
        if (word.isEmpty()) {
            throw new SyntaxException(structNode.getPlace(), String.format("Missing locator for object \"%s\"", objectName));
        }
        return word;
    }

    private List<String> getAllCurrentGroups() {
        LinkedList<String> allCurrentGroups = new LinkedList<String>();
        Iterator it = this.groupStack.iterator();
        while (it.hasNext()) {
            for (String groupName : (List)it.next()) {
                if (allCurrentGroups.contains(groupName)) continue;
                allCurrentGroups.add(groupName);
            }
        }
        return allCurrentGroups;
    }
}

