/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.speclang2.pagespec.StructNodeProcessor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class OnFilterProcessor
implements StructNodeProcessor {
    private final PageSpecHandler pageSpecHandler;

    public OnFilterProcessor(PageSpecHandler pageSpecHandler) {
        this.pageSpecHandler = pageSpecHandler;
    }

    @Override
    public List<StructNode> process(StringCharReader reader, StructNode statementNode) {
        String rest = reader.getTheRest().trim().trim();
        if (rest.isEmpty()) {
            throw new SyntaxException(statementNode, "Missing tags");
        }
        List<String> pageSpecTags = this.pageSpecHandler.getSectionFilter().getIncludedTags();
        List<String> filterTags = this.parseTagsFrom(rest);
        if (!this.containsExcludedTags(filterTags, this.pageSpecHandler.getSectionFilter().getExcludedTags())) {
            for (String filterTag : filterTags) {
                if (!filterTag.equals("*") && (pageSpecTags == null || !pageSpecTags.contains(filterTag))) continue;
                return statementNode.getChildNodes();
            }
        }
        return Collections.emptyList();
    }

    private List<String> parseTagsFrom(String text) {
        String[] filterTagsArr = text.split(",");
        LinkedList<String> list = new LinkedList<String>();
        for (String filterTag : filterTagsArr) {
            String trimmedFilterTag = filterTag.trim();
            list.add(trimmedFilterTag);
        }
        return list;
    }

    private boolean containsExcludedTags(List<String> filterTags, List<String> excludedTags) {
        if (excludedTags != null) {
            for (String excludedTag : excludedTags) {
                if (!filterTags.contains(excludedTag)) continue;
                return true;
            }
        }
        return false;
    }
}

