/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs;

import com.galenframework.specs.RangeValue;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Range {
    private RangeValue from;
    private RangeValue to;
    private String percentageOfValue;
    private RangeType rangeType = RangeType.BETWEEN;

    public Range(RangeValue from, RangeValue to) {
        this.from = from;
        this.to = to;
    }

    public int findPrecision() {
        int precision1 = 0;
        int precision2 = 0;
        if (this.from != null) {
            precision1 = this.from.getPrecision();
        }
        if (this.to != null) {
            precision2 = this.to.getPrecision();
        }
        return Math.max(precision1, precision2);
    }

    public RangeValue getFrom() {
        return this.from;
    }

    public RangeValue getTo() {
        return this.to;
    }

    public static Range exact(RangeValue number) {
        return new Range(number, number).withType(RangeType.EXACT);
    }

    public Range withType(RangeType rangeType) {
        this.setRangeType(rangeType);
        return this;
    }

    public static Range between(RangeValue from, RangeValue to) {
        return new Range(from, to).withType(RangeType.BETWEEN);
    }

    public static Range between(int from, int to) {
        return Range.between(new RangeValue(from), new RangeValue(to));
    }

    public static Range exact(int value) {
        return Range.exact(new RangeValue(value));
    }

    public static Range greaterThan(int value) {
        return Range.greaterThan(new RangeValue(value));
    }

    public static Range lessThan(int value) {
        return Range.lessThan(new RangeValue(value));
    }

    public static Range lessThanOrEquals(int value) {
        return Range.lessThanOrEquals(new RangeValue(value));
    }

    public static Range greaterThanOrEquals(int value) {
        return Range.greaterThanOrEquals(new RangeValue(value));
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 19).append((Object)this.from).append((Object)this.to).append((Object)this.percentageOfValue).append((Object)this.rangeType).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range rhs = (Range)obj;
        return new EqualsBuilder().append((Object)this.from, (Object)rhs.from).append((Object)this.to, (Object)rhs.to).append((Object)this.percentageOfValue, (Object)rhs.percentageOfValue).append((Object)this.rangeType, (Object)rhs.rangeType).isEquals();
    }

    public String toString() {
        String withPercentage = "";
        if (this.percentageOfValue != null) {
            withPercentage = " % of " + this.percentageOfValue;
        }
        return String.format("Range{%s%s}", this.prettyString(), withPercentage);
    }

    public boolean holds(double offset) {
        if (this.rangeType == RangeType.GREATER_THAN) {
            return this.from.isLessThan(offset);
        }
        if (this.rangeType == RangeType.GREATER_THAN_OR_EQUALS) {
            return this.from.isLessThanOrEquals(offset);
        }
        if (this.rangeType == RangeType.LESS_THAN) {
            return this.to.isGreaterThan(offset);
        }
        if (this.rangeType == RangeType.LESS_THAN_OR_EQUALS) {
            return this.to.isGreaterThanOrEquals(offset);
        }
        return this.from.isLessThanOrEquals(offset) && this.to.isGreaterThanOrEquals(offset);
    }

    public String prettyString() {
        return this.prettyString("px");
    }

    public String prettyString(String dimension) {
        if (this.rangeType == RangeType.EXACT) {
            return String.format("%s%s", this.from.toString(), dimension);
        }
        if (this.rangeType == RangeType.GREATER_THAN) {
            return String.format("> %s%s", this.from.toString(), dimension);
        }
        if (this.rangeType == RangeType.LESS_THAN) {
            return String.format("< %s%s", this.to.toString(), dimension);
        }
        if (this.rangeType == RangeType.LESS_THAN_OR_EQUALS) {
            return String.format("<= %s%s", this.to.toString(), dimension);
        }
        if (this.rangeType == RangeType.GREATER_THAN_OR_EQUALS) {
            return String.format(">= %s%s", this.from.toString(), dimension);
        }
        return String.format("%s to %s%s", this.from.toString(), this.to.toString(), dimension);
    }

    public Range withPercentOf(String percentageOfValue) {
        this.setPercentageOfValue(percentageOfValue);
        return this;
    }

    public String getPercentageOfValue() {
        return this.percentageOfValue;
    }

    public void setPercentageOfValue(String percentageOfValue) {
        this.percentageOfValue = percentageOfValue;
    }

    public boolean isPercentage() {
        return this.percentageOfValue != null && !this.percentageOfValue.isEmpty();
    }

    public static Range greaterThan(RangeValue value) {
        return new Range(value, null).withType(RangeType.GREATER_THAN);
    }

    public static Range lessThan(RangeValue value) {
        return new Range(null, value).withType(RangeType.LESS_THAN);
    }

    public static Range lessThanOrEquals(RangeValue value) {
        return new Range(null, value).withType(RangeType.LESS_THAN_OR_EQUALS);
    }

    public static Range greaterThanOrEquals(RangeValue value) {
        return new Range(value, null).withType(RangeType.GREATER_THAN_OR_EQUALS);
    }

    public RangeType getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(RangeType rangeType) {
        this.rangeType = rangeType;
    }

    public String getErrorMessageSuffix() {
        if (this.isPercentage()) {
            return this.getErrorMessageSuffix("%");
        }
        return this.getErrorMessageSuffix("px");
    }

    public String getErrorMessageSuffix(String dimension) {
        if (this.rangeType == RangeType.EXACT) {
            return String.format("instead of %s", this.prettyString(dimension));
        }
        if (this.rangeType == RangeType.BETWEEN) {
            return String.format("which is not in range of %s", this.prettyString(dimension));
        }
        if (this.rangeType == RangeType.GREATER_THAN) {
            return String.format("but it should be greater than %s%s", this.from.toString(), dimension);
        }
        if (this.rangeType == RangeType.GREATER_THAN_OR_EQUALS) {
            return String.format("but it should be greater than or equal to %s%s", this.from.toString(), dimension);
        }
        if (this.rangeType == RangeType.LESS_THAN) {
            return String.format("but it should be less than %s%s", this.to.toString(), dimension);
        }
        if (this.rangeType == RangeType.LESS_THAN_OR_EQUALS) {
            return String.format("but it should be less than or equal to %s%s", this.to.toString(), dimension);
        }
        return "but the expected range is unknown";
    }

    public static enum RangeType {
        BETWEEN,
        EXACT,
        GREATER_THAN,
        LESS_THAN,
        LESS_THAN_OR_EQUALS,
        GREATER_THAN_OR_EQUALS;

    }
}

