/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs.page;

import com.galenframework.parser.AlphanumericComparator;
import com.galenframework.speclang2.specs.SpecReader;
import com.galenframework.specs.page.Locator;
import com.galenframework.specs.page.ObjectSpecs;
import com.galenframework.specs.page.PageSection;
import com.galenframework.utils.GalenUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PageSpec {
    private final Map<String, Locator> objects = new HashMap<String, Locator>();
    private final List<PageSection> sections = new LinkedList<PageSection>();
    private final Map<String, List<String>> objectGroups = new HashMap<String, List<String>>();

    public PageSpec() {
    }

    public PageSpec(Map<String, Locator> objects) {
        this.setObjects(objects);
    }

    public Map<String, Locator> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<String, Locator> objects) {
        this.objects.clear();
        if (objects != null) {
            this.objects.putAll(objects);
        }
    }

    public void setObjectGroups(Map<String, List<String>> objectGroups) {
        this.objectGroups.clear();
        if (objectGroups != null) {
            this.objectGroups.putAll(objectGroups);
        }
    }

    public List<PageSection> getSections() {
        return this.sections;
    }

    public void setSections(List<PageSection> sections) {
        this.sections.clear();
        if (sections != null) {
            this.sections.addAll(sections);
        }
    }

    public void addSection(PageSection section) {
        this.sections.add(section);
    }

    public void addObject(String objectName, Locator locator) {
        this.objects.put(objectName, locator);
    }

    public Locator getObjectLocator(String objectName) {
        return this.objects.get(objectName);
    }

    public List<String> findOnlyExistingMatchingObjectNames(String objectExpression) {
        String[] parts = objectExpression.split(",");
        List<String> allSortedObjectNames = this.getSortedObjectNames();
        LinkedList<String> resultingObjectNames = new LinkedList<String>();
        for (String part : parts) {
            String singleExpression = part.trim();
            if (singleExpression.isEmpty()) continue;
            if (GalenUtils.isObjectGroup(singleExpression)) {
                resultingObjectNames.addAll(this.findObjectsInGroup(GalenUtils.extractGroupName(singleExpression)));
                continue;
            }
            if (GalenUtils.isObjectsSearchExpression(singleExpression)) {
                Pattern objectPattern = GalenUtils.convertObjectNameRegex(singleExpression);
                for (String objectName : allSortedObjectNames) {
                    if (!objectPattern.matcher(objectName).matches()) continue;
                    resultingObjectNames.add(objectName);
                }
                continue;
            }
            if (!this.objects.containsKey(singleExpression)) continue;
            resultingObjectNames.add(singleExpression);
        }
        return resultingObjectNames;
    }

    public List<String> findAllObjectsMatchingStrictStatements(String objectExpression) {
        String[] parts = objectExpression.split(",");
        List<String> allSortedObjectNames = this.getSortedObjectNames();
        LinkedList<String> resultingObjectNames = new LinkedList<String>();
        for (String part : parts) {
            String singleExpression = part.trim();
            if (singleExpression.isEmpty()) continue;
            if (GalenUtils.isObjectGroup(singleExpression)) {
                resultingObjectNames.addAll(this.findObjectsInGroup(GalenUtils.extractGroupName(singleExpression)));
                continue;
            }
            if (GalenUtils.isObjectsSearchExpression(singleExpression)) {
                Pattern objectPattern = GalenUtils.convertObjectNameRegex(singleExpression);
                for (String objectName : allSortedObjectNames) {
                    if (!objectPattern.matcher(objectName).matches()) continue;
                    resultingObjectNames.add(objectName);
                }
                continue;
            }
            resultingObjectNames.add(singleExpression);
        }
        return resultingObjectNames;
    }

    public List<String> getSortedObjectNames() {
        ArrayList<String> list = new ArrayList<String>(this.getObjects().keySet());
        Collections.sort(list, new AlphanumericComparator());
        return list;
    }

    public List<String> findObjectsInGroup(String groupName) {
        if (this.getObjectGroups().containsKey(groupName)) {
            return this.getObjectGroups().get(groupName);
        }
        return Collections.emptyList();
    }

    public void merge(PageSpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException("Cannot merge null spec");
        }
        this.objects.putAll(spec.getObjects());
        this.sections.addAll(spec.getSections());
        this.objectGroups.putAll(spec.getObjectGroups());
    }

    public void clearSections() {
        this.sections.clear();
    }

    public void addSpec(String sectionName, String objectName, String specText) {
        PageSection pageSection = this.findSection(sectionName);
        if (pageSection == null) {
            pageSection = new PageSection(sectionName);
            this.sections.add(pageSection);
        }
        ObjectSpecs objectSpecs = new ObjectSpecs(objectName);
        objectSpecs.addSpec(new SpecReader().read(specText));
        pageSection.addObjects(objectSpecs);
    }

    private PageSection findSection(String sectionName) {
        for (PageSection section : this.sections) {
            if (!section.getName().equals(sectionName)) continue;
            return section;
        }
        return null;
    }

    public Map<String, List<String>> getObjectGroups() {
        return this.objectGroups;
    }
}

