/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.actions;

import com.galenframework.browser.Browser;
import com.galenframework.page.Page;
import com.galenframework.page.PageElement;
import com.galenframework.reports.TestReport;
import com.galenframework.specs.page.Locator;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.validation.ValidationListener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GalenPageActionWait
extends GalenPageAction {
    private int timeout;
    private List<Until> untilElements;

    @Override
    public void execute(TestReport report, Browser browser, GalenPageTest pageTest, ValidationListener validationListener) throws Exception {
        Page page = browser.getPage();
        if (this.untilElements == null || this.untilElements.isEmpty()) {
            Thread.sleep(this.timeout);
        } else {
            int period = 500;
            int tries = this.timeout / period;
            while (tries-- > 0) {
                Thread.sleep(period);
                if (!this.checkAllConditions(page, null)) continue;
                return;
            }
            StringBuffer results = new StringBuffer();
            if (!this.checkAllConditions(page, results)) {
                throw new TimeoutException("Failed waiting for:\n" + results.toString());
            }
        }
    }

    private boolean checkAllConditions(Page page, StringBuffer result) {
        boolean state = true;
        for (Until until : this.untilElements) {
            PageElement element = page.getObject(until.getLocator());
            if (this.checkElement(element, until)) continue;
            state = false;
            if (result == null) continue;
            result.append(" - " + until.getType().toString() + " " + until.getLocator().prettyString() + "\n");
        }
        return state;
    }

    private boolean checkElement(PageElement element, Until until) {
        if (until.getType() == UntilType.VISIBLE) {
            return element.isVisible();
        }
        if (until.getType() == UntilType.HIDDEN) {
            return !element.isVisible();
        }
        if (until.getType() == UntilType.EXIST) {
            return element.isPresent();
        }
        if (until.getType() == UntilType.GONE) {
            return !element.isPresent();
        }
        return true;
    }

    public GalenPageActionWait withTimeout(int timeoutInMillis) {
        this.setTimeout(timeoutInMillis);
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("timeout", this.timeout).append("untilElements", this.untilElements).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GalenPageActionWait)) {
            return false;
        }
        GalenPageActionWait rhs = (GalenPageActionWait)obj;
        return new EqualsBuilder().append(this.timeout, rhs.timeout).append(this.untilElements, rhs.untilElements).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.timeout).append(this.untilElements).toHashCode();
    }

    public List<Until> getUntilElements() {
        return this.untilElements;
    }

    public void setUntilElements(List<Until> untilElements) {
        this.untilElements = untilElements;
    }

    public GalenPageActionWait withUntilElements(List<Until> list) {
        if (this.untilElements == null) {
            this.untilElements = new LinkedList<Until>();
        }
        this.untilElements.addAll(list);
        return this;
    }

    public static class Until {
        private UntilType type;
        private Locator locator;

        public Until(UntilType type, Locator locator) {
            this.type = type;
            this.locator = locator;
        }

        public UntilType getType() {
            return this.type;
        }

        public void setType(UntilType type) {
            this.type = type;
        }

        public Locator getLocator() {
            return this.locator;
        }

        public void setLocator(Locator locator) {
            this.locator = locator;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Until)) {
                return false;
            }
            Until rhs = (Until)obj;
            return new EqualsBuilder().append((Object)this.type, (Object)rhs.type).append((Object)this.locator, (Object)rhs.locator).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.type).append((Object)this.locator).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("type", (Object)this.type).append("locator", (Object)this.locator).toString();
        }
    }

    public static enum UntilType {
        EXIST,
        GONE,
        VISIBLE,
        HIDDEN;


        public static UntilType parseNonStrict(String text) {
            if ("visible".equals(text)) {
                return VISIBLE;
            }
            if ("hidden".equals(text)) {
                return HIDDEN;
            }
            if ("exist".equals(text)) {
                return EXIST;
            }
            if ("gone".equals(text)) {
                return GONE;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case EXIST: {
                    return "exist";
                }
                case GONE: {
                    return "gone";
                }
                case VISIBLE: {
                    return "visible";
                }
                case HIDDEN: {
                    return "hidden";
                }
            }
            return "";
        }
    }
}

