/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.reader;

import com.galenframework.parser.SyntaxException;
import com.galenframework.parser.VarsContext;
import com.galenframework.specs.Place;
import com.galenframework.suite.reader.Node;
import com.galenframework.suite.reader.ParameterizedNode;
import com.galenframework.suite.reader.TestNode;
import com.galenframework.tests.GalenBasicTest;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RootNode
extends Node<List<GalenBasicTest>> {
    public RootNode() {
        super(null, null);
    }

    @Override
    public Node<?> findProcessingNodeByIndentation(int spaces) {
        return this;
    }

    @Override
    public Node<?> processNewNode(String text, Place place) {
        if (text.startsWith(" ")) {
            throw new SyntaxException(place, "Should not start with space");
        }
        TestNode suiteNode = new TestNode(text, place);
        this.add(suiteNode);
        return suiteNode;
    }

    @Override
    public List<GalenBasicTest> build(VarsContext context) {
        this.rearrangeNodes();
        LinkedList<GalenBasicTest> suites = new LinkedList<GalenBasicTest>();
        for (Node<?> childNode : this.getChildNodes()) {
            if (childNode instanceof TestNode) {
                TestNode suiteNode = (TestNode)childNode;
                if (!suiteNode.isEnabled()) continue;
                suites.add(suiteNode.build(context));
                continue;
            }
            if (childNode instanceof ParameterizedNode) {
                ParameterizedNode parameterizedNode = (ParameterizedNode)childNode;
                if (!parameterizedNode.isEnabled()) continue;
                suites.addAll((Collection<GalenBasicTest>)parameterizedNode.build(context));
                continue;
            }
            childNode.build(context);
        }
        return suites;
    }

    private void rearrangeNodes() {
        Iterator<Node<?>> it = this.getChildNodes().iterator();
        ParameterizedNode currentParameterizedNode = null;
        while (it.hasNext()) {
            Node<?> node = it.next();
            if (node instanceof ParameterizedNode) {
                if (currentParameterizedNode != null) {
                    currentParameterizedNode.setToParameterize(node);
                    currentParameterizedNode = (ParameterizedNode)node;
                    it.remove();
                    continue;
                }
                currentParameterizedNode = (ParameterizedNode)node;
                continue;
            }
            if (!(node instanceof TestNode) || currentParameterizedNode == null) continue;
            currentParameterizedNode.setToParameterize(node);
            it.remove();
            currentParameterizedNode = null;
        }
    }
}

