/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.reader;

import com.galenframework.parser.SyntaxException;
import com.galenframework.parser.VarsContext;
import com.galenframework.specs.Place;
import com.galenframework.suite.reader.Node;
import com.galenframework.suite.reader.Table;
import com.galenframework.suite.reader.TableRowNode;
import java.util.List;

public class TableNode
extends Node<Void> {
    public TableNode(String text, Place place) {
        super(text, place);
    }

    @Override
    public Void build(VarsContext context) {
        String name = this.getArguments().trim();
        if (name.isEmpty()) {
            throw new SyntaxException(this.getPlace(), "Table name should not be empty");
        }
        Table table = new Table();
        for (Node<?> childNode : this.getChildNodes()) {
            if (!(childNode instanceof TableRowNode)) continue;
            TableRowNode rowNode = (TableRowNode)childNode;
            try {
                table.addRow((List<String>)rowNode.build(context), rowNode.getPlace());
            }
            catch (SyntaxException e) {
                e.setPlace(childNode.getPlace());
                throw e;
            }
        }
        context.putValue(name, table);
        return null;
    }

    @Override
    public Node<?> processNewNode(String text, Place place) {
        this.add(new TableRowNode(text, place));
        return this;
    }
}

