/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.specs.Spec;
import com.galenframework.specs.page.ObjectSpecs;
import com.galenframework.specs.page.PageSection;
import com.galenframework.specs.page.SpecGroup;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationListener;
import com.galenframework.validation.ValidationResult;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionValidation {
    private static final Logger LOG = LoggerFactory.getLogger(SectionValidation.class);
    private List<PageSection> pageSections;
    private PageValidation pageValidation;
    private ValidationListener validationListener;

    public SectionValidation(List<PageSection> pageSections, PageValidation pageValidation, ValidationListener validationListener) {
        this.pageSections = pageSections;
        this.pageValidation = pageValidation;
        this.validationListener = validationListener;
    }

    public List<ValidationResult> check() {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        Pattern sectionFilter = this.createSectionFilter(this.pageValidation.getSectionFilter());
        for (PageSection section : this.pageSections) {
            if (!this.appliesToFilter(section, sectionFilter)) continue;
            validationResults.addAll(this.checkPageSection(section));
        }
        return validationResults;
    }

    private Pattern createSectionFilter(SectionFilter sectionFilter) {
        if (sectionFilter != null && sectionFilter.getSectionName() != null) {
            return Pattern.compile(sectionFilter.getSectionName().replace("*", ".*"));
        }
        return null;
    }

    private boolean appliesToFilter(PageSection section, Pattern sectionFilter) {
        if (sectionFilter != null) {
            return sectionFilter.matcher(section.getName()).matches();
        }
        return true;
    }

    private List<ValidationResult> checkPageSection(PageSection section) {
        LinkedList<ValidationResult> validationResult = new LinkedList<ValidationResult>();
        validationResult.addAll(this.checkSection(section));
        return validationResult;
    }

    private void tellAfterSection(PageSection section) {
        if (this.validationListener != null) {
            this.validationListener.onAfterSection(this.pageValidation, section);
        }
    }

    private void tellBeforeSection(PageSection section) {
        if (this.validationListener != null) {
            this.validationListener.onBeforeSection(this.pageValidation, section);
        }
    }

    private List<ValidationResult> checkObjects(List<ObjectSpecs> objects) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (ObjectSpecs object : objects) {
            this.tellOnObject(object.getObjectName());
            validationResults.addAll(this.checkObject(object.getObjectName(), object.getSpecs()));
            validationResults.addAll(this.checkSpecGroups(object.getObjectName(), object.getSpecGroups()));
            this.tellOnAfterObject(object.getObjectName());
        }
        return validationResults;
    }

    private List<ValidationResult> checkSpecGroups(String objectName, List<SpecGroup> specGroups) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        if (specGroups != null) {
            for (SpecGroup specGroup : specGroups) {
                this.tellOnSpecGroup(specGroup);
                validationResults.addAll(this.checkObject(objectName, specGroup.getSpecs()));
                this.tellOnAfterSpecGroup(specGroup);
            }
        }
        return validationResults;
    }

    private List<ValidationResult> checkSection(PageSection section) {
        this.tellBeforeSection(section);
        LinkedList<ValidationResult> result = new LinkedList<ValidationResult>();
        if (section.getSections() != null) {
            for (PageSection subSection : section.getSections()) {
                result.addAll(this.checkSection(subSection));
            }
        }
        result.addAll(this.checkObjects(section.getObjects()));
        this.tellAfterSection(section);
        return result;
    }

    private void tellOnAfterObject(String objectName) {
        if (this.validationListener != null) {
            try {
                this.validationListener.onAfterObject(this.pageValidation, objectName);
            }
            catch (Exception e) {
                LOG.trace("Unknown error during validation after object", (Throwable)e);
            }
        }
    }

    private void tellOnObject(String objectName) {
        if (this.validationListener != null) {
            try {
                this.validationListener.onObject(this.pageValidation, objectName);
            }
            catch (Exception e) {
                LOG.trace("Unknown error during validation on object", (Throwable)e);
            }
        }
    }

    private void tellOnSpecGroup(SpecGroup specGroup) {
        if (this.validationListener != null) {
            try {
                this.validationListener.onSpecGroup(this.pageValidation, specGroup.getName());
            }
            catch (Exception e) {
                LOG.trace("Unknown error during validation of spec group", (Throwable)e);
            }
        }
    }

    private void tellOnAfterSpecGroup(SpecGroup specGroup) {
        if (this.validationListener != null) {
            try {
                this.validationListener.onAfterSpecGroup(this.pageValidation, specGroup.getName());
            }
            catch (Exception e) {
                LOG.trace("Unknown error during validation of spec group", (Throwable)e);
            }
        }
    }

    private List<ValidationResult> checkObject(String objectName, List<Spec> specs) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (Spec spec : specs) {
            this.tellBeforeSpec(this.pageValidation, objectName, spec);
            ValidationResult result = this.pageValidation.check(objectName, spec);
            if (result.getError() != null) {
                validationResults.add(result);
                this.tellOnSpecError(this.pageValidation, objectName, spec, result);
                continue;
            }
            this.tellOnSpecSuccess(this.pageValidation, objectName, spec, result);
        }
        return validationResults;
    }

    private void tellBeforeSpec(PageValidation pageValidation, String objectName, Spec spec) {
        try {
            if (this.validationListener != null) {
                this.validationListener.onBeforeSpec(pageValidation, objectName, spec);
            }
        }
        catch (Exception e) {
            LOG.trace("Unknown error during before spec event", (Throwable)e);
        }
    }

    private void tellOnSpecError(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        try {
            if (this.validationListener != null) {
                this.validationListener.onSpecError(pageValidation, objectName, spec, result);
            }
        }
        catch (Exception e) {
            LOG.trace("Unknown error during tell spec error", (Throwable)e);
        }
    }

    private void tellOnSpecSuccess(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        try {
            if (this.validationListener != null) {
                this.validationListener.onSpecSuccess(pageValidation, objectName, spec, result);
            }
        }
        catch (Exception e) {
            LOG.trace("Unknown error during tell spec success", (Throwable)e);
        }
    }
}

