/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.page.PageElement;
import com.galenframework.specs.SpecCount;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SpecValidationCount
extends SpecValidation<SpecCount> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, SpecCount spec) throws ValidationErrorException {
        String filterName;
        Map<String, PageElement> reportElements;
        Map<String, PageElement> filteredElements;
        List<String> matchingNames = pageValidation.getPageSpec().findOnlyExistingMatchingObjectNames(spec.getPattern());
        if (spec.getFetchType() == SpecCount.FetchType.ANY) {
            reportElements = filteredElements = this.findAllObjects(pageValidation, matchingNames);
            filterName = "";
        } else if (spec.getFetchType() == SpecCount.FetchType.VISIBLE) {
            reportElements = filteredElements = this.findVisibleObjects(pageValidation, matchingNames);
            filterName = " visible";
        } else if (spec.getFetchType() == SpecCount.FetchType.ABSENT) {
            filteredElements = this.findAbsentObjects(pageValidation, matchingNames);
            reportElements = Collections.emptyMap();
            filterName = " absent";
        } else {
            throw new ValidationErrorException("Unknown filter: " + spec.getFetchType().toString().toLowerCase());
        }
        if (spec.getAmount().holds(filteredElements.size())) {
            return new ValidationResult(spec, this.convertToValidationObjects(reportElements));
        }
        throw new ValidationErrorException().withValidationObjects(this.convertToValidationObjects(reportElements)).withMessage(String.format("There are %d%s objects matching \"%s\" %s", filteredElements.size(), filterName, spec.getPattern(), spec.getAmount().getErrorMessageSuffix("")));
    }

    private List<ValidationObject> convertToValidationObjects(Map<String, PageElement> reportElements) {
        LinkedList<ValidationObject> validationObjects = new LinkedList<ValidationObject>();
        for (Map.Entry<String, PageElement> element : reportElements.entrySet()) {
            validationObjects.add(new ValidationObject(element.getValue().getArea(), element.getKey()));
        }
        return validationObjects;
    }

    private Map<String, PageElement> findAllObjects(PageValidation pageValidation, List<String> matchingNames) {
        HashMap<String, PageElement> objects = new HashMap<String, PageElement>();
        for (String name : matchingNames) {
            objects.put(name, pageValidation.findPageElement(name));
        }
        return objects;
    }

    private Map<String, PageElement> findVisibleObjects(PageValidation pageValidation, List<String> matchingNames) {
        HashMap<String, PageElement> objects = new HashMap<String, PageElement>();
        for (String name : matchingNames) {
            PageElement pageElement = pageValidation.findPageElement(name);
            if (!pageElement.isVisible() || !pageElement.isPresent()) continue;
            objects.put(name, pageElement);
        }
        return objects;
    }

    private Map<String, PageElement> findAbsentObjects(PageValidation pageValidation, List<String> matchingNames) {
        HashMap<String, PageElement> objects = new HashMap<String, PageElement>();
        for (String name : matchingNames) {
            PageElement pageElement = pageValidation.findPageElement(name);
            if (pageElement.isVisible() && pageElement.isPresent()) continue;
            objects.put(name, pageElement);
        }
        return objects;
    }
}

