/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.ocr.GoogleVisionOcrService;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecAbove;
import com.galenframework.specs.SpecAbsent;
import com.galenframework.specs.SpecBelow;
import com.galenframework.specs.SpecCentered;
import com.galenframework.specs.SpecColorScheme;
import com.galenframework.specs.SpecComponent;
import com.galenframework.specs.SpecContains;
import com.galenframework.specs.SpecCount;
import com.galenframework.specs.SpecCss;
import com.galenframework.specs.SpecHeight;
import com.galenframework.specs.SpecHorizontally;
import com.galenframework.specs.SpecImage;
import com.galenframework.specs.SpecInside;
import com.galenframework.specs.SpecLeftOf;
import com.galenframework.specs.SpecNear;
import com.galenframework.specs.SpecOcr;
import com.galenframework.specs.SpecOn;
import com.galenframework.specs.SpecRightOf;
import com.galenframework.specs.SpecText;
import com.galenframework.specs.SpecVertically;
import com.galenframework.specs.SpecVisible;
import com.galenframework.specs.SpecWidth;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.SpecValidationCount;
import com.galenframework.validation.SpecValidationCss;
import com.galenframework.validation.specs.SpecValidationAbsent;
import com.galenframework.validation.specs.SpecValidationCentered;
import com.galenframework.validation.specs.SpecValidationColorScheme;
import com.galenframework.validation.specs.SpecValidationComponent;
import com.galenframework.validation.specs.SpecValidationContains;
import com.galenframework.validation.specs.SpecValidationDirectionPosition;
import com.galenframework.validation.specs.SpecValidationHeight;
import com.galenframework.validation.specs.SpecValidationHorizontally;
import com.galenframework.validation.specs.SpecValidationImage;
import com.galenframework.validation.specs.SpecValidationInside;
import com.galenframework.validation.specs.SpecValidationNear;
import com.galenframework.validation.specs.SpecValidationOcr;
import com.galenframework.validation.specs.SpecValidationOn;
import com.galenframework.validation.specs.SpecValidationText;
import com.galenframework.validation.specs.SpecValidationVertically;
import com.galenframework.validation.specs.SpecValidationVisible;
import com.galenframework.validation.specs.SpecValidationWidth;
import java.util.HashMap;
import java.util.Map;

public class ValidationFactory {
    private Map<Class<? extends Spec>, SpecValidation> validations = new HashMap<Class<? extends Spec>, SpecValidation>();
    private static ValidationFactory _instance = null;

    private ValidationFactory() {
        this.initValidations();
    }

    public static synchronized ValidationFactory get() {
        if (_instance == null) {
            _instance = new ValidationFactory();
        }
        return _instance;
    }

    private void initValidations() {
        this.validations.put(SpecContains.class, new SpecValidationContains());
        this.validations.put(SpecAbsent.class, new SpecValidationAbsent());
        this.validations.put(SpecVisible.class, new SpecValidationVisible());
        this.validations.put(SpecInside.class, new SpecValidationInside());
        this.validations.put(SpecNear.class, new SpecValidationNear());
        this.validations.put(SpecWidth.class, new SpecValidationWidth());
        this.validations.put(SpecHeight.class, new SpecValidationHeight());
        this.validations.put(SpecHorizontally.class, new SpecValidationHorizontally());
        this.validations.put(SpecVertically.class, new SpecValidationVertically());
        this.validations.put(SpecText.class, new SpecValidationText());
        this.validations.put(SpecAbove.class, new SpecValidationDirectionPosition(SpecValidationDirectionPosition.Direction.ABOVE));
        this.validations.put(SpecBelow.class, new SpecValidationDirectionPosition(SpecValidationDirectionPosition.Direction.BELOW));
        this.validations.put(SpecLeftOf.class, new SpecValidationDirectionPosition(SpecValidationDirectionPosition.Direction.LEFT_OF));
        this.validations.put(SpecRightOf.class, new SpecValidationDirectionPosition(SpecValidationDirectionPosition.Direction.RIGHT_OF));
        this.validations.put(SpecCentered.class, new SpecValidationCentered());
        this.validations.put(SpecOn.class, new SpecValidationOn());
        this.validations.put(SpecComponent.class, new SpecValidationComponent());
        this.validations.put(SpecColorScheme.class, new SpecValidationColorScheme());
        this.validations.put(SpecImage.class, new SpecValidationImage());
        this.validations.put(SpecCss.class, new SpecValidationCss());
        this.validations.put(SpecCount.class, new SpecValidationCount());
        this.validations.put(SpecOcr.class, new SpecValidationOcr(new GoogleVisionOcrService()));
    }

    public static SpecValidation<? extends Spec> getValidation(Spec spec, PageValidation pageValidation) {
        SpecValidation specValidation = ValidationFactory.get().validations.get(spec.getClass());
        if (specValidation == null) {
            throw new RuntimeException("There is no known validation for spec " + spec.getClass());
        }
        return specValidation;
    }
}

