/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.browser.Browser;
import com.galenframework.page.Page;
import com.galenframework.page.PageElement;
import com.galenframework.speclang2.pagespec.PageSpecReader;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.specs.SpecComponent;
import com.galenframework.specs.page.Locator;
import com.galenframework.specs.page.PageSpec;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SectionValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationError;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationListener;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecValidationComponent
extends SpecValidation<SpecComponent> {
    private static final Logger LOG = LoggerFactory.getLogger(SpecValidationComponent.class);
    private static final Map<String, Locator> NO_OBJECTS = Collections.emptyMap();

    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, SpecComponent spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        this.tellListenerSubLayout(pageValidation, objectName);
        List<ValidationResult> results = spec.isFrame() ? this.checkInsideFrame(mainObject, pageValidation, spec) : this.checkInsideNormalWebElement(pageValidation, objectName, spec);
        this.tellListenerAfterSubLayout(pageValidation, objectName);
        List<ValidationObject> objects = Arrays.asList(new ValidationObject(mainObject.getArea(), objectName));
        List<ValidationResult> errorResults = results.stream().filter(this.byOnlyError()).collect(Collectors.toList());
        if (!errorResults.isEmpty()) {
            throw new ValidationErrorException("Child component spec contains " + errorResults.size() + " errors").withValidationObjects(objects).withChildValidationResults(errorResults);
        }
        List<ValidationResult> warningResults = results.stream().filter(this.byOnlyWarn()).collect(Collectors.toList());
        if (!warningResults.isEmpty()) {
            return new ValidationResult(spec, objects).withError(new ValidationError(Arrays.asList("Child component spec contains " + warningResults.size() + " warnings")).withOnlyWarn(true)).withChildValidationResults(warningResults);
        }
        return new ValidationResult(spec, objects);
    }

    private void tellListenerAfterSubLayout(PageValidation pageValidation, String objectName) {
        if (pageValidation.getValidationListener() != null) {
            try {
                pageValidation.getValidationListener().onAfterSubLayout(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during validation after object", (Throwable)ex);
            }
        }
    }

    private void tellListenerSubLayout(PageValidation pageValidation, String objectName) {
        if (pageValidation.getValidationListener() != null) {
            try {
                pageValidation.getValidationListener().onSubLayout(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during validation after object", (Throwable)ex);
            }
        }
    }

    private List<ValidationResult> checkInsideFrame(PageElement mainObject, PageValidation pageValidation, SpecComponent spec) {
        Page page = pageValidation.getPage();
        Page framePage = page.createFrameContext(mainObject);
        List<ValidationResult> results = this.checkInsidePage(pageValidation.getBrowser(), framePage, spec, pageValidation.getSectionFilter(), pageValidation.getValidationListener());
        if (spec.isFrame()) {
            page.switchToParentFrame();
        }
        return results;
    }

    private List<ValidationResult> checkInsidePage(Browser browser, Page page, SpecComponent spec, SectionFilter sectionFilter, ValidationListener validationListener) {
        PageSpec componentPageSpec;
        PageSpecReader pageSpecReader = new PageSpecReader();
        try {
            componentPageSpec = pageSpecReader.read(spec.getSpecPath(), page, sectionFilter, spec.getProperties(), this.wrapJsVariables(spec.getJsVariables(), spec.getArguments()), NO_OBJECTS);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read spec " + spec.getSpecPath(), e);
        }
        SectionValidation sectionValidation = new SectionValidation(componentPageSpec.getSections(), new PageValidation(browser, page, componentPageSpec, validationListener, sectionFilter), validationListener);
        return sectionValidation.check();
    }

    private Map<String, Object> wrapJsVariables(Map<String, Object> jsVariables, Map<String, Object> arguments) {
        HashMap<String, Object> newJsVariables = new HashMap<String, Object>();
        if (jsVariables != null) {
            newJsVariables.putAll(jsVariables);
        }
        if (arguments != null) {
            newJsVariables.putAll(arguments);
        }
        return newJsVariables;
    }

    private List<ValidationResult> checkInsideNormalWebElement(PageValidation pageValidation, String objectName, SpecComponent spec) {
        Locator mainObjectLocator = pageValidation.getPageSpec().getObjectLocator(objectName);
        Page objectContextPage = pageValidation.getPage().createObjectContextPage(mainObjectLocator);
        return this.checkInsidePage(pageValidation.getBrowser(), objectContextPage, spec, pageValidation.getSectionFilter(), pageValidation.getValidationListener());
    }

    private Predicate<ValidationResult> byOnlyWarn() {
        return r -> r.getError() != null && r.getError().isOnlyWarn();
    }

    private Predicate<ValidationResult> byOnlyError() {
        return r -> r.getError() != null && !r.getError().isOnlyWarn();
    }
}

