/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Point;
import com.galenframework.page.Rect;
import com.galenframework.specs.SpecContains;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.util.LinkedList;
import java.util.List;

public class SpecValidationContains
extends SpecValidation<SpecContains> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, SpecContains spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        Rect objectArea = mainObject.getArea();
        List<String> allFoundObjects = this.findChildObjects(pageValidation, spec);
        LinkedList<String> errorMessages = new LinkedList<String>();
        LinkedList<ValidationObject> objects = new LinkedList<ValidationObject>();
        objects.add(new ValidationObject(objectArea, objectName));
        for (String childObjectName : allFoundObjects) {
            PageElement childObject = pageValidation.findPageElement(childObjectName);
            if (childObject != null) {
                if (!childObject.isPresent()) {
                    throw new ValidationErrorException().withMessage(String.format("\"%s\" is absent on page", childObjectName));
                }
                if (!childObject.isVisible()) {
                    throw new ValidationErrorException().withMessage(String.format("\"%s\" is not visible on page", childObjectName));
                }
                Rect childObjectArea = childObject.getArea();
                objects.add(new ValidationObject(childObjectArea, childObjectName));
                if (this.childObjectMatches(spec, objectArea, childObjectArea)) continue;
                errorMessages.add(String.format("\"%s\" is outside \"%s\"", childObjectName, objectName));
                continue;
            }
            throw new ValidationErrorException().withMessage(String.format("Cannot find locator for \"%s\" in page spec", childObjectName));
        }
        if (errorMessages.size() > 0) {
            throw new ValidationErrorException(objects, errorMessages);
        }
        return new ValidationResult(spec, objects);
    }

    private List<String> findChildObjects(PageValidation pageValidation, SpecContains spec) throws ValidationErrorException {
        LinkedList<String> allFoundObjects = new LinkedList<String>();
        for (String objectStatement : spec.getChildObjects()) {
            List<String> objects = pageValidation.getPageSpec().findAllObjectsMatchingStrictStatements(objectStatement);
            if (objects.isEmpty()) {
                throw new ValidationErrorException("There are no objects matching: " + objectStatement);
            }
            allFoundObjects.addAll(objects);
        }
        return allFoundObjects;
    }

    private boolean childObjectMatches(SpecContains spec, Rect objectArea, Rect childObjectArea) {
        int matchingPoints = this.findMatchingPoints(objectArea, childObjectArea);
        if (spec.isPartly()) {
            return matchingPoints > 0;
        }
        return matchingPoints == 4;
    }

    private int findMatchingPoints(Rect objectArea, Rect childObjectArea) {
        Point[] childPoints = childObjectArea.getPoints();
        int matchingPoints = 0;
        for (Point point : childPoints) {
            if (!objectArea.contains(point)) continue;
            ++matchingPoints;
        }
        return matchingPoints;
    }
}

