/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.specs.Side;
import com.galenframework.specs.SpecDirectionPosition;
import com.galenframework.validation.MetaBasedValidation;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SimpleValidationResult;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.util.Arrays;
import java.util.List;

public class SpecValidationDirectionPosition
extends SpecValidation<SpecDirectionPosition> {
    private Direction direction;

    public SpecValidationDirectionPosition(Direction direction) {
        this.direction = direction;
    }

    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, SpecDirectionPosition spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        PageElement secondObject = pageValidation.findPageElement(spec.getObject());
        this.checkAvailability(secondObject, spec.getObject());
        Rect mainArea = mainObject.getArea();
        Rect secondArea = secondObject.getArea();
        List<ValidationObject> objects = Arrays.asList(new ValidationObject(mainArea, objectName), new ValidationObject(secondArea, spec.getObject()));
        SimpleValidationResult svr = MetaBasedValidation.forObjectsWithRange(objectName, spec.getObject(), spec.getRange()).withFirstEdge(this.direction.firstEdge).withSecondEdge(this.direction.secondEdge).withInvertedCalculation(this.direction == Direction.LEFT_OF || this.direction == Direction.ABOVE).validate(mainArea, secondArea, pageValidation, this.direction.toString());
        if (svr.isError()) {
            throw new ValidationErrorException().withMessage(String.format("\"%s\" is %s \"%s\" %s", objectName, svr.getError(), spec.getObject(), spec.getRange().getErrorMessageSuffix())).withValidationObjects(objects).withMeta(Arrays.asList(svr.getMeta()));
        }
        return new ValidationResult(spec, objects).withMeta(Arrays.asList(svr.getMeta()));
    }

    public static enum Direction {
        ABOVE("above", Side.BOTTOM, Side.TOP),
        BELOW("below", Side.TOP, Side.BOTTOM),
        LEFT_OF("left of", Side.RIGHT, Side.LEFT),
        RIGHT_OF("right of", Side.LEFT, Side.RIGHT);

        private final String reportingName;
        private final Side firstEdge;
        private final Side secondEdge;

        private Direction(String reportingName, Side firstEdge, Side secondEdge) {
            this.reportingName = reportingName;
            this.firstEdge = firstEdge;
            this.secondEdge = secondEdge;
        }

        public String toString() {
            return this.reportingName;
        }
    }
}

